/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.base;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.VersionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class GeneratorBase
extends JsonGenerator {
    protected ObjectCodec _objectCodec;
    protected int _features;
    protected boolean _cfgNumbersAsStrings;
    protected JsonWriteContext _writeContext;
    protected boolean _closed;

    protected GeneratorBase(int n, ObjectCodec objectCodec) {
        this._features = n;
        this._writeContext = JsonWriteContext.createRootContext();
        this._objectCodec = objectCodec;
        this._cfgNumbersAsStrings = this.isEnabled(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS);
    }

    @Override
    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        this._features |= feature.getMask();
        if (feature == JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS) {
            this._cfgNumbersAsStrings = true;
        } else if (feature == JsonGenerator.Feature.ESCAPE_NON_ASCII) {
            this.setHighestNonEscapedChar(127);
        }
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        this._features &= ~feature.getMask();
        if (feature == JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS) {
            this._cfgNumbersAsStrings = false;
        } else if (feature == JsonGenerator.Feature.ESCAPE_NON_ASCII) {
            this.setHighestNonEscapedChar(0);
        }
        return this;
    }

    @Override
    public final boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._features & feature.getMask()) != 0;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        if (this.getPrettyPrinter() != null) {
            return this;
        }
        return this.setPrettyPrinter(new DefaultPrettyPrinter());
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    @Override
    public final ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public final JsonWriteContext getOutputContext() {
        return this._writeContext;
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeFieldName(serializableString.getValue());
    }

    @Override
    public void writeString(SerializableString serializableString) throws IOException, JsonGenerationException {
        this.writeString(serializableString.getValue());
    }

    @Override
    public void writeRawValue(String string2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(string2);
    }

    @Override
    public void writeRawValue(String string2, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(string2, n, n2);
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(cArray, n, n2);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
        return 0;
    }

    @Override
    public void writeObject(Object object) throws IOException, JsonProcessingException {
        if (object == null) {
            this.writeNull();
        } else {
            if (this._objectCodec != null) {
                this._objectCodec.writeValue(this, object);
                return;
            }
            this._writeSimpleObject(object);
        }
    }

    @Override
    public void writeTree(TreeNode treeNode) throws IOException, JsonProcessingException {
        if (treeNode == null) {
            this.writeNull();
        } else {
            if (this._objectCodec == null) {
                throw new IllegalStateException("No ObjectCodec defined");
            }
            this._objectCodec.writeValue(this, treeNode);
        }
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public void close() throws IOException {
        this._closed = true;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public final void copyCurrentEvent(JsonParser jsonParser) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null) {
            this._reportError("No current event to copy");
        }
        block0 : switch (jsonToken) {
            case START_OBJECT: {
                this.writeStartObject();
                break;
            }
            case END_OBJECT: {
                this.writeEndObject();
                break;
            }
            case START_ARRAY: {
                this.writeStartArray();
                break;
            }
            case END_ARRAY: {
                this.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                this.writeFieldName(jsonParser.getCurrentName());
                break;
            }
            case VALUE_STRING: {
                if (jsonParser.hasTextCharacters()) {
                    this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    break;
                }
                this.writeString(jsonParser.getText());
                break;
            }
            case VALUE_NUMBER_INT: {
                switch (jsonParser.getNumberType()) {
                    case INT: {
                        this.writeNumber(jsonParser.getIntValue());
                        break block0;
                    }
                    case BIG_INTEGER: {
                        this.writeNumber(jsonParser.getBigIntegerValue());
                        break block0;
                    }
                }
                this.writeNumber(jsonParser.getLongValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                switch (jsonParser.getNumberType()) {
                    case BIG_DECIMAL: {
                        this.writeNumber(jsonParser.getDecimalValue());
                        break block0;
                    }
                    case FLOAT: {
                        this.writeNumber(jsonParser.getFloatValue());
                        break block0;
                    }
                }
                this.writeNumber(jsonParser.getDoubleValue());
                break;
            }
            case VALUE_TRUE: {
                this.writeBoolean(true);
                break;
            }
            case VALUE_FALSE: {
                this.writeBoolean(false);
                break;
            }
            case VALUE_NULL: {
                this.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                this.writeObject(jsonParser.getEmbeddedObject());
                break;
            }
            default: {
                this._throwInternal();
            }
        }
    }

    @Override
    public final void copyCurrentStructure(JsonParser jsonParser) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            this.writeFieldName(jsonParser.getCurrentName());
            jsonToken = jsonParser.nextToken();
        }
        switch (jsonToken) {
            case START_ARRAY: {
                this.writeStartArray();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndArray();
                break;
            }
            case START_OBJECT: {
                this.writeStartObject();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndObject();
                break;
            }
            default: {
                this.copyCurrentEvent(jsonParser);
            }
        }
    }

    protected abstract void _releaseBuffers();

    protected abstract void _verifyValueWrite(String var1) throws IOException, JsonGenerationException;

    protected void _reportError(String string2) throws JsonGenerationException {
        throw new JsonGenerationException(string2);
    }

    protected void _writeSimpleObject(Object object) throws IOException, JsonGenerationException {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof String) {
            this.writeString((String)object);
            return;
        }
        if (object instanceof Number) {
            Number number2 = (Number)object;
            if (number2 instanceof Integer) {
                this.writeNumber(number2.intValue());
                return;
            }
            if (number2 instanceof Long) {
                this.writeNumber(number2.longValue());
                return;
            }
            if (number2 instanceof Double) {
                this.writeNumber(number2.doubleValue());
                return;
            }
            if (number2 instanceof Float) {
                this.writeNumber(number2.floatValue());
                return;
            }
            if (number2 instanceof Short) {
                this.writeNumber(number2.shortValue());
                return;
            }
            if (number2 instanceof Byte) {
                this.writeNumber(number2.byteValue());
                return;
            }
            if (number2 instanceof BigInteger) {
                this.writeNumber((BigInteger)number2);
                return;
            }
            if (number2 instanceof BigDecimal) {
                this.writeNumber((BigDecimal)number2);
                return;
            }
            if (number2 instanceof AtomicInteger) {
                this.writeNumber(((AtomicInteger)number2).get());
                return;
            }
            if (number2 instanceof AtomicLong) {
                this.writeNumber(((AtomicLong)number2).get());
                return;
            }
        } else {
            if (object instanceof byte[]) {
                this.writeBinary((byte[])object);
                return;
            }
            if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
                return;
            }
            if (object instanceof AtomicBoolean) {
                this.writeBoolean(((AtomicBoolean)object).get());
                return;
            }
        }
        throw new IllegalStateException("No ObjectCodec defined for the generator, can only serialize simple wrapper types (type passed " + object.getClass().getName() + ")");
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by generator of type " + this.getClass().getName());
    }
}

