/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class InjectableValues {
    public abstract Object findInjectableValue(Object var1, DeserializationContext var2, BeanProperty var3, Object var4);

    public static class Std
    extends InjectableValues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Map<String, Object> _values;

        public Std() {
            this(new HashMap<String, Object>());
        }

        public Std(Map<String, Object> map2) {
            this._values = map2;
        }

        public Std addValue(String string2, Object object) {
            this._values.put(string2, object);
            return this;
        }

        public Std addValue(Class<?> clazz, Object object) {
            this._values.put(clazz.getName(), object);
            return this;
        }

        @Override
        public Object findInjectableValue(Object object, DeserializationContext deserializationContext, BeanProperty beanProperty, Object object2) {
            if (!(object instanceof String)) {
                String string2 = object == null ? "[null]" : object.getClass().getName();
                throw new IllegalArgumentException("Unrecognized inject value id type (" + string2 + "), expecting String");
            }
            String string3 = (String)object;
            Object object3 = this._values.get(string3);
            if (object3 == null && !this._values.containsKey(string3)) {
                throw new IllegalArgumentException("No injectable id with value '" + string3 + "' found (for property '" + beanProperty.getName() + "')");
            }
            return object3;
        }
    }
}

