/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import java.io.Serializable;

public class PropertyName
implements Serializable {
    private static final long serialVersionUID = 7930806520033045126L;
    private static final String _USE_DEFAULT = "";
    private static final String _NO_NAME = "#disabled";
    public static final PropertyName USE_DEFAULT = new PropertyName("", null);
    public static final PropertyName NO_NAME = new PropertyName(new String("#disabled"), null);
    protected final String _simpleName;
    protected final String _namespace;

    public PropertyName(String string2) {
        this(string2, null);
    }

    public PropertyName(String string2, String string3) {
        this._simpleName = string2 == null ? _USE_DEFAULT : string2;
        this._namespace = string3;
    }

    protected Object readResolve() {
        if (this._simpleName == null || _USE_DEFAULT.equals(this._simpleName)) {
            return USE_DEFAULT;
        }
        if (this._simpleName.equals(_NO_NAME)) {
            return NO_NAME;
        }
        return this;
    }

    public static PropertyName construct(String string2, String string3) {
        if (string2 == null) {
            string2 = _USE_DEFAULT;
        }
        if (string3 == null && string2.length() == 0) {
            return USE_DEFAULT;
        }
        return new PropertyName(string2, string3);
    }

    public PropertyName withSimpleName(String string2) {
        if (string2 == null) {
            string2 = _USE_DEFAULT;
        }
        if (string2.equals(this._simpleName)) {
            return this;
        }
        return new PropertyName(string2, this._namespace);
    }

    public PropertyName withNamespace(String string2) {
        if (string2 == null ? this._namespace == null : string2.equals(this._namespace)) {
            return this;
        }
        return new PropertyName(this._simpleName, string2);
    }

    public String getSimpleName() {
        return this._simpleName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public boolean hasSimpleName() {
        return this._simpleName.length() > 0;
    }

    public boolean hasNamespace() {
        return this._namespace != null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        PropertyName propertyName = (PropertyName)object;
        if (this._simpleName == null ? propertyName._simpleName != null : !this._simpleName.equals(propertyName._simpleName)) {
            return false;
        }
        if (this._namespace == null) {
            return null == propertyName._namespace;
        }
        return this._namespace.equals(propertyName._namespace);
    }

    public int hashCode() {
        if (this._namespace == null) {
            return this._simpleName.hashCode();
        }
        return this._namespace.hashCode() ^ this._simpleName.hashCode();
    }

    public String toString() {
        if (this._namespace == null) {
            return this._simpleName;
        }
        return "{" + this._namespace + "}" + this._simpleName;
    }
}

