/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import java.io.Serializable;

public abstract class PropertyNamingStrategy
implements Serializable {
    public static final PropertyNamingStrategy CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES = new LowerCaseWithUnderscoresStrategy();
    public static final PropertyNamingStrategy PASCAL_CASE_TO_CAMEL_CASE = new PascalCaseStrategy();

    public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string2) {
        return string2;
    }

    public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string2) {
        return string2;
    }

    public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string2) {
        return string2;
    }

    public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string2) {
        return string2;
    }

    public static class PascalCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string2) {
            if (string2 == null || string2.length() == 0) {
                return string2;
            }
            char c = string2.charAt(0);
            if (Character.isUpperCase(c)) {
                return string2;
            }
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.setCharAt(0, Character.toUpperCase(c));
            return stringBuilder.toString();
        }
    }

    public static class LowerCaseWithUnderscoresStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string2) {
            if (string2 == null) {
                return string2;
            }
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n * 2);
            int n2 = 0;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (i <= 0 && c == '_') continue;
                if (Character.isUpperCase(c)) {
                    if (!bl && n2 > 0 && stringBuilder.charAt(n2 - 1) != '_') {
                        stringBuilder.append('_');
                        ++n2;
                    }
                    c = Character.toLowerCase(c);
                    bl = true;
                } else {
                    bl = false;
                }
                stringBuilder.append(c);
                ++n2;
            }
            return n2 > 0 ? stringBuilder.toString() : string2;
        }
    }

    public static abstract class PropertyNamingStrategyBase
    extends PropertyNamingStrategy {
        @Override
        public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string2) {
            return this.translate(string2);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string2) {
            return this.translate(string2);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string2) {
            return this.translate(string2);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string2) {
            return this.translate(string2);
        }

        public abstract String translate(String var1);
    }
}

