/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BuilderBasedDeserializer;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.fasterxml.jackson.databind.deser.impl.ValueInjector;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.Annotations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BeanDeserializerBuilder {
    protected final BeanDescription _beanDesc;
    protected final boolean _defaultViewInclusion;
    protected final Map<String, SettableBeanProperty> _properties = new LinkedHashMap<String, SettableBeanProperty>();
    protected List<ValueInjector> _injectables;
    protected HashMap<String, SettableBeanProperty> _backRefProperties;
    protected HashSet<String> _ignorableProps;
    protected ValueInstantiator _valueInstantiator;
    protected ObjectIdReader _objectIdReader;
    protected SettableAnyProperty _anySetter;
    protected boolean _ignoreAllUnknown;
    protected AnnotatedMethod _buildMethod;
    protected JsonPOJOBuilder.Value _builderConfig;

    public BeanDeserializerBuilder(BeanDescription beanDescription, DeserializationConfig deserializationConfig) {
        this._beanDesc = beanDescription;
        this._defaultViewInclusion = deserializationConfig.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
    }

    protected BeanDeserializerBuilder(BeanDeserializerBuilder beanDeserializerBuilder) {
        this._beanDesc = beanDeserializerBuilder._beanDesc;
        this._defaultViewInclusion = beanDeserializerBuilder._defaultViewInclusion;
        this._anySetter = beanDeserializerBuilder._anySetter;
        this._ignoreAllUnknown = beanDeserializerBuilder._ignoreAllUnknown;
        this._properties.putAll(beanDeserializerBuilder._properties);
        this._backRefProperties = BeanDeserializerBuilder._copy(beanDeserializerBuilder._backRefProperties);
        this._ignorableProps = beanDeserializerBuilder._ignorableProps;
        this._valueInstantiator = beanDeserializerBuilder._valueInstantiator;
        this._objectIdReader = beanDeserializerBuilder._objectIdReader;
        this._buildMethod = beanDeserializerBuilder._buildMethod;
        this._builderConfig = beanDeserializerBuilder._builderConfig;
    }

    private static HashMap<String, SettableBeanProperty> _copy(HashMap<String, SettableBeanProperty> hashMap) {
        if (hashMap == null) {
            return null;
        }
        return new HashMap<String, SettableBeanProperty>(hashMap);
    }

    public void addOrReplaceProperty(SettableBeanProperty settableBeanProperty, boolean bl) {
        this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
    }

    public void addProperty(SettableBeanProperty settableBeanProperty) {
        SettableBeanProperty settableBeanProperty2 = this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
        if (settableBeanProperty2 != null && settableBeanProperty2 != settableBeanProperty) {
            throw new IllegalArgumentException("Duplicate property '" + settableBeanProperty.getName() + "' for " + this._beanDesc.getType());
        }
    }

    public void addBackReferenceProperty(String string2, SettableBeanProperty settableBeanProperty) {
        if (this._backRefProperties == null) {
            this._backRefProperties = new HashMap(4);
        }
        this._backRefProperties.put(string2, settableBeanProperty);
        if (this._properties != null) {
            this._properties.remove(settableBeanProperty.getName());
        }
    }

    public void addInjectable(String string2, JavaType javaType, Annotations annotations, AnnotatedMember annotatedMember, Object object) {
        if (this._injectables == null) {
            this._injectables = new ArrayList<ValueInjector>();
        }
        this._injectables.add(new ValueInjector(string2, javaType, annotations, annotatedMember, object));
    }

    public void addIgnorable(String string2) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(string2);
    }

    public void addCreatorProperty(SettableBeanProperty settableBeanProperty) {
        this.addProperty(settableBeanProperty);
    }

    @Deprecated
    public void addCreatorProperty(BeanPropertyDefinition beanPropertyDefinition) {
    }

    public void setAnySetter(SettableAnyProperty settableAnyProperty) {
        if (this._anySetter != null && settableAnyProperty != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = settableAnyProperty;
    }

    public void setIgnoreUnknownProperties(boolean bl) {
        this._ignoreAllUnknown = bl;
    }

    public void setValueInstantiator(ValueInstantiator valueInstantiator) {
        this._valueInstantiator = valueInstantiator;
    }

    public void setObjectIdReader(ObjectIdReader objectIdReader) {
        this._objectIdReader = objectIdReader;
    }

    public void setPOJOBuilder(AnnotatedMethod annotatedMethod, JsonPOJOBuilder.Value value2) {
        this._buildMethod = annotatedMethod;
        this._builderConfig = value2;
    }

    public Iterator<SettableBeanProperty> getProperties() {
        return this._properties.values().iterator();
    }

    public SettableBeanProperty findProperty(String string2) {
        return this._properties.get(string2);
    }

    public boolean hasProperty(String string2) {
        return this.findProperty(string2) != null;
    }

    public SettableBeanProperty removeProperty(String string2) {
        return this._properties.remove(string2);
    }

    public SettableAnyProperty getAnySetter() {
        return this._anySetter;
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public List<ValueInjector> getInjectables() {
        return this._injectables;
    }

    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public AnnotatedMethod getBuildMethod() {
        return this._buildMethod;
    }

    public JsonPOJOBuilder.Value getBuilderConfig() {
        return this._builderConfig;
    }

    public JsonDeserializer<?> build() {
        boolean bl;
        Collection<SettableBeanProperty> collection = this._properties.values();
        BeanPropertyMap beanPropertyMap = new BeanPropertyMap(collection);
        beanPropertyMap.assignIndexes();
        boolean bl2 = bl = !this._defaultViewInclusion;
        if (!bl) {
            for (SettableBeanProperty settableBeanProperty : collection) {
                if (!settableBeanProperty.hasViews()) continue;
                bl = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty objectIdValueProperty = new ObjectIdValueProperty(this._objectIdReader, true);
            beanPropertyMap = beanPropertyMap.withProperty(objectIdValueProperty);
        }
        return new BeanDeserializer(this, this._beanDesc, beanPropertyMap, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, bl);
    }

    public AbstractDeserializer buildAbstract() {
        return new AbstractDeserializer(this, this._beanDesc, this._backRefProperties);
    }

    public JsonDeserializer<?> buildBuilderBased(JavaType javaType, String string2) {
        boolean bl;
        if (this._buildMethod == null) {
            throw new IllegalArgumentException("Builder class " + this._beanDesc.getBeanClass().getName() + " does not have build method '" + string2 + "()'");
        }
        Class<?> clazz = this._buildMethod.getRawReturnType();
        if (!javaType.getRawClass().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Build method '" + this._buildMethod.getFullName() + " has bad return type (" + clazz.getName() + "), not compatible with POJO type (" + javaType.getRawClass().getName() + ")");
        }
        Collection<SettableBeanProperty> collection = this._properties.values();
        BeanPropertyMap beanPropertyMap = new BeanPropertyMap(collection);
        beanPropertyMap.assignIndexes();
        boolean bl2 = bl = !this._defaultViewInclusion;
        if (!bl) {
            for (SettableBeanProperty settableBeanProperty : collection) {
                if (!settableBeanProperty.hasViews()) continue;
                bl = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty objectIdValueProperty = new ObjectIdValueProperty(this._objectIdReader, true);
            beanPropertyMap = beanPropertyMap.withProperty(objectIdValueProperty);
        }
        return new BuilderBasedDeserializer(this, this._beanDesc, beanPropertyMap, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, bl);
    }
}

