/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import java.io.IOException;
import java.lang.reflect.Method;

public final class SettableAnyProperty {
    protected final BeanProperty _property;
    protected final Method _setter;
    protected final JavaType _type;
    protected JsonDeserializer<Object> _valueDeserializer;

    public SettableAnyProperty(BeanProperty beanProperty, AnnotatedMethod annotatedMethod, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) {
        this(beanProperty, annotatedMethod.getAnnotated(), javaType, jsonDeserializer);
    }

    public SettableAnyProperty(BeanProperty beanProperty, Method method, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) {
        this._property = beanProperty;
        this._type = javaType;
        this._setter = method;
        this._valueDeserializer = jsonDeserializer;
    }

    public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
        return new SettableAnyProperty(this._property, this._setter, this._type, jsonDeserializer);
    }

    public BeanProperty getProperty() {
        return this._property;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public JavaType getType() {
        return this._type;
    }

    public final void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string2) throws IOException, JsonProcessingException {
        this.set(object, string2, this.deserialize(jsonParser, deserializationContext));
    }

    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
    }

    public final void set(Object object, String string2, Object object2) throws IOException {
        try {
            this._setter.invoke(object, string2, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, string2, object2);
        }
    }

    protected void _throwAsIOE(Exception exception, String string2, Object object) throws IOException {
        if (exception instanceof IllegalArgumentException) {
            String string3 = object == null ? "[NULL]" : object.getClass().getName();
            StringBuilder stringBuilder = new StringBuilder("Problem deserializing \"any\" property '").append(string2);
            stringBuilder.append("' of class " + this.getClassName() + " (expected type: ").append(this._type);
            stringBuilder.append("; actual type: ").append(string3).append(")");
            String string4 = exception.getMessage();
            if (string4 != null) {
                stringBuilder.append(", problem: ").append(string4);
            } else {
                stringBuilder.append(" (no error message provided)");
            }
            throw new JsonMappingException(stringBuilder.toString(), null, exception);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        Throwable throwable = exception;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        throw new JsonMappingException(throwable.getMessage(), null, throwable);
    }

    private String getClassName() {
        return this._setter.getDeclaringClass().getName();
    }

    public String toString() {
        return "[any property on class " + this.getClassName() + "]";
    }
}

