/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;

public class JacksonDeserializers {
    @Deprecated
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{JavaTypeDeserializer.instance, TokenBufferDeserializer.instance};
    }

    public static JsonDeserializer<?> find(Class<?> clazz) {
        if (clazz == TokenBuffer.class) {
            return TokenBufferDeserializer.instance;
        }
        if (JavaType.class.isAssignableFrom(clazz)) {
            return JavaTypeDeserializer.instance;
        }
        return null;
    }

    public static ValueInstantiator findValueInstantiator(DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        if (beanDescription.getBeanClass() == JsonLocation.class) {
            return JsonLocationInstantiator.instance;
        }
        return null;
    }

    @JacksonStdImpl
    public static class TokenBufferDeserializer
    extends StdScalarDeserializer<TokenBuffer> {
        public static final TokenBufferDeserializer instance = new TokenBufferDeserializer();

        public TokenBufferDeserializer() {
            super(TokenBuffer.class);
        }

        @Override
        public TokenBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
            tokenBuffer.copyCurrentStructure(jsonParser);
            return tokenBuffer;
        }
    }

    public static class JsonLocationInstantiator
    extends ValueInstantiator {
        public static final JsonLocationInstantiator instance = new JsonLocationInstantiator();

        @Override
        public String getValueTypeDesc() {
            return JsonLocation.class.getName();
        }

        @Override
        public boolean canCreateFromObjectWith() {
            return true;
        }

        public CreatorProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
            JavaType javaType = deserializationConfig.constructType(Integer.TYPE);
            JavaType javaType2 = deserializationConfig.constructType(Long.TYPE);
            return new CreatorProperty[]{JsonLocationInstantiator.creatorProp("sourceRef", deserializationConfig.constructType(Object.class), 0), JsonLocationInstantiator.creatorProp("byteOffset", javaType2, 1), JsonLocationInstantiator.creatorProp("charOffset", javaType2, 2), JsonLocationInstantiator.creatorProp("lineNr", javaType, 3), JsonLocationInstantiator.creatorProp("columnNr", javaType, 4)};
        }

        private static CreatorProperty creatorProp(String string2, JavaType javaType, int n) {
            return new CreatorProperty(string2, javaType, null, null, null, null, n, null, true);
        }

        @Override
        public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) {
            return new JsonLocation(objectArray[0], JsonLocationInstantiator._long(objectArray[1]), JsonLocationInstantiator._long(objectArray[2]), JsonLocationInstantiator._int(objectArray[3]), JsonLocationInstantiator._int(objectArray[4]));
        }

        private static final long _long(Object object) {
            return object == null ? 0L : ((Number)object).longValue();
        }

        private static final int _int(Object object) {
            return object == null ? 0 : ((Number)object).intValue();
        }
    }

    public static class JavaTypeDeserializer
    extends StdScalarDeserializer<JavaType> {
        public static final JavaTypeDeserializer instance = new JavaTypeDeserializer();

        public JavaTypeDeserializer() {
            super(JavaType.class);
        }

        @Override
        public JavaType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_STRING) {
                String string2 = jsonParser.getText().trim();
                if (string2.length() == 0) {
                    return (JavaType)this.getEmptyValue();
                }
                return deserializationContext.getTypeFactory().constructFromCanonical(string2);
            }
            if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return (JavaType)jsonParser.getEmbeddedObject();
            }
            throw deserializationContext.mappingException(this._valueClass);
        }
    }
}

