/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.exc;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class UnrecognizedPropertyException
extends JsonMappingException {
    private static final long serialVersionUID = 1L;
    protected final Class<?> _referringClass;
    protected final String _unrecognizedPropertyName;
    protected final Collection<Object> _propertyIds;
    protected transient String _propertiesAsString;
    private static final int MAX_DESC_LENGTH = 200;

    public UnrecognizedPropertyException(String string2, JsonLocation jsonLocation, Class<?> clazz, String string3, Collection<Object> collection) {
        super(string2, jsonLocation);
        this._referringClass = clazz;
        this._unrecognizedPropertyName = string3;
        this._propertyIds = collection;
    }

    public static UnrecognizedPropertyException from(JsonParser jsonParser, Object object, String string2, Collection<Object> collection) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        String string3 = "Unrecognized field \"" + string2 + "\" (class " + clazz.getName() + "), not marked as ignorable";
        UnrecognizedPropertyException unrecognizedPropertyException = new UnrecognizedPropertyException(string3, jsonParser.getCurrentLocation(), clazz, string2, collection);
        unrecognizedPropertyException.prependPath(object, string2);
        return unrecognizedPropertyException;
    }

    @Override
    public String getMessageSuffix() {
        String string2 = this._propertiesAsString;
        if (string2 == null && this._propertyIds != null) {
            StringBuilder stringBuilder = new StringBuilder(100);
            int n = this._propertyIds.size();
            if (n == 1) {
                stringBuilder.append(" (one known property: \"");
                stringBuilder.append(String.valueOf(this._propertyIds.iterator().next()));
                stringBuilder.append('\"');
            } else {
                stringBuilder.append(" (").append(n).append(" known properties: ");
                Iterator<Object> iterator2 = this._propertyIds.iterator();
                while (iterator2.hasNext()) {
                    stringBuilder.append(", \"");
                    stringBuilder.append(String.valueOf(iterator2.next()));
                    stringBuilder.append('\"');
                    if (stringBuilder.length() <= 200) continue;
                    stringBuilder.append(" [truncated]");
                    break;
                }
            }
            stringBuilder.append("])");
            this._propertiesAsString = string2 = stringBuilder.toString();
        }
        return string2;
    }

    public Class<?> getReferringClass() {
        return this._referringClass;
    }

    public String getUnrecognizedPropertyName() {
        return this._unrecognizedPropertyName;
    }

    public Collection<Object> getKnownPropertyIds() {
        if (this._propertyIds == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this._propertyIds);
    }
}

