/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class StdSubtypeResolver
extends SubtypeResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected LinkedHashSet<NamedType> _registeredSubtypes;

    @Override
    public void registerSubtypes(NamedType ... namedTypeArray) {
        if (this._registeredSubtypes == null) {
            this._registeredSubtypes = new LinkedHashSet();
        }
        for (NamedType namedType : namedTypeArray) {
            this._registeredSubtypes.add(namedType);
        }
    }

    @Override
    public void registerSubtypes(Class<?> ... classArray) {
        NamedType[] namedTypeArray = new NamedType[classArray.length];
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            namedTypeArray[i] = new NamedType(classArray[i]);
        }
        this.registerSubtypes(namedTypeArray);
    }

    @Override
    @Deprecated
    public Collection<NamedType> collectAndResolveSubtypes(AnnotatedMember annotatedMember, MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector) {
        return this.collectAndResolveSubtypes(annotatedMember, mapperConfig, annotationIntrospector, null);
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypes(AnnotatedMember annotatedMember, MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, JavaType javaType) {
        Object object;
        Object object2;
        Object object3;
        Class<?> clazz = javaType == null ? annotatedMember.getRawType() : javaType.getRawClass();
        HashMap<NamedType, NamedType> hashMap = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            object3 = this._registeredSubtypes.iterator();
            while (object3.hasNext()) {
                object2 = (NamedType)object3.next();
                if (!clazz.isAssignableFrom(((NamedType)object2).getType())) continue;
                object = AnnotatedClass.constructWithoutSuperTypes(((NamedType)object2).getType(), annotationIntrospector, mapperConfig);
                this._collectAndResolve((AnnotatedClass)object, (NamedType)object2, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        if ((object3 = annotationIntrospector.findSubtypes(annotatedMember)) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (NamedType)object2.next();
                AnnotatedClass annotatedClass = AnnotatedClass.constructWithoutSuperTypes(((NamedType)object).getType(), annotationIntrospector, mapperConfig);
                this._collectAndResolve(annotatedClass, (NamedType)object, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        object2 = new NamedType(clazz, null);
        object = AnnotatedClass.constructWithoutSuperTypes(clazz, annotationIntrospector, mapperConfig);
        this._collectAndResolve((AnnotatedClass)object, (NamedType)object2, mapperConfig, annotationIntrospector, hashMap);
        return new ArrayList<NamedType>(hashMap.values());
    }

    @Override
    public Collection<NamedType> collectAndResolveSubtypes(AnnotatedClass annotatedClass, MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector) {
        Serializable serializable2;
        HashMap<NamedType, NamedType> hashMap = new HashMap<NamedType, NamedType>();
        if (this._registeredSubtypes != null) {
            serializable2 = annotatedClass.getRawType();
            for (NamedType namedType : this._registeredSubtypes) {
                if (!((Class)serializable2).isAssignableFrom(namedType.getType())) continue;
                AnnotatedClass annotatedClass2 = AnnotatedClass.constructWithoutSuperTypes(namedType.getType(), annotationIntrospector, mapperConfig);
                this._collectAndResolve(annotatedClass2, namedType, mapperConfig, annotationIntrospector, hashMap);
            }
        }
        serializable2 = new NamedType(annotatedClass.getRawType(), null);
        this._collectAndResolve(annotatedClass, (NamedType)serializable2, mapperConfig, annotationIntrospector, hashMap);
        return new ArrayList<NamedType>(hashMap.values());
    }

    protected void _collectAndResolve(AnnotatedClass annotatedClass, NamedType namedType, MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, HashMap<NamedType, NamedType> hashMap) {
        List<NamedType> list2;
        if (!namedType.hasName() && (list2 = annotationIntrospector.findTypeName(annotatedClass)) != null) {
            namedType = new NamedType(namedType.getType(), (String)((Object)list2));
        }
        if (hashMap.containsKey(namedType)) {
            if (namedType.hasName() && !((NamedType)((Object)(list2 = hashMap.get(namedType)))).hasName()) {
                hashMap.put(namedType, namedType);
            }
            return;
        }
        hashMap.put(namedType, namedType);
        list2 = annotationIntrospector.findSubtypes(annotatedClass);
        if (list2 != null && !list2.isEmpty()) {
            for (NamedType namedType2 : list2) {
                AnnotatedClass annotatedClass2 = AnnotatedClass.constructWithoutSuperTypes(namedType2.getType(), annotationIntrospector, mapperConfig);
                if (!namedType2.hasName()) {
                    namedType2 = new NamedType(namedType2.getType(), annotationIntrospector.findTypeName(annotatedClass2));
                }
                this._collectAndResolve(annotatedClass2, namedType2, mapperConfig, annotationIntrospector, hashMap);
            }
        }
    }
}

