/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;

public class BeanUtil {
    public static String okNameForGetter(AnnotatedMethod annotatedMethod) {
        String string2 = annotatedMethod.getName();
        String string3 = BeanUtil.okNameForIsGetter(annotatedMethod, string2);
        if (string3 == null) {
            string3 = BeanUtil.okNameForRegularGetter(annotatedMethod, string2);
        }
        return string3;
    }

    public static String okNameForRegularGetter(AnnotatedMethod annotatedMethod, String string2) {
        if (string2.startsWith("get")) {
            if ("getCallbacks".equals(string2) ? BeanUtil.isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string2) && BeanUtil.isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            return BeanUtil.manglePropertyName(string2.substring(3));
        }
        return null;
    }

    public static String okNameForIsGetter(AnnotatedMethod annotatedMethod, String string2) {
        if (string2.startsWith("is")) {
            Class<?> clazz = annotatedMethod.getRawType();
            if (clazz != Boolean.class && clazz != Boolean.TYPE) {
                return null;
            }
            return BeanUtil.manglePropertyName(string2.substring(2));
        }
        return null;
    }

    public static String okNameForSetter(AnnotatedMethod annotatedMethod) {
        String string2 = BeanUtil.okNameForMutator(annotatedMethod, "set");
        if (string2 != null) {
            if ("metaClass".equals(string2) && BeanUtil.isGroovyMetaClassSetter(annotatedMethod)) {
                return null;
            }
            return string2;
        }
        return null;
    }

    public static String okNameForMutator(AnnotatedMethod annotatedMethod, String string2) {
        String string3 = annotatedMethod.getName();
        if (string3.startsWith(string2)) {
            return BeanUtil.manglePropertyName(string3.substring(string2.length()));
        }
        return null;
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMethod annotatedMethod) {
        String string2;
        Class<?> clazz = annotatedMethod.getRawType();
        if (clazz == null || !clazz.isArray()) {
            return false;
        }
        Class<?> clazz2 = clazz.getComponentType();
        Package package_ = clazz2.getPackage();
        return package_ != null && ((string2 = package_.getName()).startsWith("net.sf.cglib") || string2.startsWith("org.hibernate.repackage.cglib"));
    }

    protected static boolean isGroovyMetaClassSetter(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawParameterType(0);
        Package package_ = clazz.getPackage();
        return package_ != null && package_.getName().startsWith("groovy.lang");
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        Class<?> clazz = annotatedMethod.getRawType();
        if (clazz == null || clazz.isArray()) {
            return false;
        }
        Package package_ = clazz.getPackage();
        return package_ != null && package_.getName().startsWith("groovy.lang");
    }

    protected static String manglePropertyName(String string2) {
        char c;
        char c2;
        int n = string2.length();
        if (n == 0) {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n && (c2 = string2.charAt(i)) != (c = Character.toLowerCase(c2)); ++i) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string2);
            }
            stringBuilder.setCharAt(i, c);
        }
        return stringBuilder == null ? string2 : stringBuilder.toString();
    }
}

