/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ISO8601Utils {
    private static final String GMT_ID = "GMT";
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");

    public static TimeZone timeZoneGMT() {
        return TIMEZONE_GMT;
    }

    public static String format(Date date) {
        return ISO8601Utils.format(date, false, TIMEZONE_GMT);
    }

    public static String format(Date date, boolean bl) {
        return ISO8601Utils.format(date, bl, TIMEZONE_GMT);
    }

    public static String format(Date date, boolean bl, TimeZone timeZone) {
        int n;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
        gregorianCalendar.setTime(date);
        int n2 = "yyyy-MM-ddThh:mm:ss".length();
        n2 += bl ? ".sss".length() : 0;
        StringBuilder stringBuilder = new StringBuilder(n2 += timeZone.getRawOffset() == 0 ? "Z".length() : "+hh:mm".length());
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(1), "yyyy".length());
        stringBuilder.append('-');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(2) + 1, "MM".length());
        stringBuilder.append('-');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(5), "dd".length());
        stringBuilder.append('T');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(11), "hh".length());
        stringBuilder.append(':');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(12), "mm".length());
        stringBuilder.append(':');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(13), "ss".length());
        if (bl) {
            stringBuilder.append('.');
            ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(14), "sss".length());
        }
        if ((n = timeZone.getOffset(gregorianCalendar.getTimeInMillis())) != 0) {
            int n3 = Math.abs(n / 60000 / 60);
            int n4 = Math.abs(n / 60000 % 60);
            stringBuilder.append(n < 0 ? (char)'-' : '+');
            ISO8601Utils.padInt(stringBuilder, n3, "hh".length());
            stringBuilder.append(':');
            ISO8601Utils.padInt(stringBuilder, n4, "mm".length());
        } else {
            stringBuilder.append('Z');
        }
        return stringBuilder.toString();
    }

    public static Date parse(String string2) {
        try {
            String string3;
            char c;
            int n = 0;
            int n2 = ISO8601Utils.parseInt(string2, n, n += 4);
            ISO8601Utils.checkOffset(string2, n, '-');
            int n3 = ISO8601Utils.parseInt(string2, ++n, n += 2);
            ISO8601Utils.checkOffset(string2, n, '-');
            int n4 = ISO8601Utils.parseInt(string2, ++n, n += 2);
            ISO8601Utils.checkOffset(string2, n, 'T');
            int n5 = ISO8601Utils.parseInt(string2, ++n, n += 2);
            ISO8601Utils.checkOffset(string2, n, ':');
            int n6 = ISO8601Utils.parseInt(string2, ++n, n += 2);
            ISO8601Utils.checkOffset(string2, n, ':');
            int n7 = ISO8601Utils.parseInt(string2, ++n, n += 2);
            int n8 = 0;
            if (string2.charAt(n) == '.') {
                ISO8601Utils.checkOffset(string2, n, '.');
                n8 = ISO8601Utils.parseInt(string2, ++n, n += 3);
            }
            if ((c = string2.charAt(n)) == '+' || c == '-') {
                string3 = GMT_ID + string2.substring(n);
            } else if (c == 'Z') {
                string3 = GMT_ID;
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator " + c);
            }
            TimeZone timeZone = TimeZone.getTimeZone(string3);
            if (!timeZone.getID().equals(string3)) {
                throw new IndexOutOfBoundsException();
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setLenient(false);
            gregorianCalendar.set(1, n2);
            gregorianCalendar.set(2, n3 - 1);
            gregorianCalendar.set(5, n4);
            gregorianCalendar.set(11, n5);
            gregorianCalendar.set(12, n6);
            gregorianCalendar.set(13, n7);
            gregorianCalendar.set(14, n8);
            return gregorianCalendar.getTime();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Failed to parse date " + string2, indexOutOfBoundsException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to parse date " + string2, numberFormatException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to parse date " + string2, illegalArgumentException);
        }
    }

    private static void checkOffset(String string2, int n, char c) throws IndexOutOfBoundsException {
        char c2 = string2.charAt(n);
        if (c2 != c) {
            throw new IndexOutOfBoundsException("Expected '" + c + "' character but found '" + c2 + "'");
        }
    }

    private static int parseInt(String string2, int n, int n2) throws NumberFormatException {
        int n3;
        if (n < 0 || n2 > string2.length() || n > n2) {
            throw new NumberFormatException(string2);
        }
        int n4 = n;
        int n5 = 0;
        if (n4 < n2) {
            if ((n3 = Character.digit(string2.charAt(n4++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + string2);
            }
            n5 = -n3;
        }
        while (n4 < n2) {
            if ((n3 = Character.digit(string2.charAt(n4++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + string2);
            }
            n5 *= 10;
            n5 -= n3;
        }
        return -n5;
    }

    private static void padInt(StringBuilder stringBuilder, int n, int n2) {
        String string2 = Integer.toString(n);
        for (int i = n2 - string2.length(); i > 0; --i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string2);
    }
}

