/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

public abstract class NameTransformer {
    public static final NameTransformer NOP = new NameTransformer(){

        @Override
        public String transform(String string2) {
            return string2;
        }

        @Override
        public String reverse(String string2) {
            return string2;
        }
    };

    protected NameTransformer() {
    }

    public static NameTransformer simpleTransformer(final String string2, final String string3) {
        boolean bl;
        boolean bl2 = string2 != null && string2.length() > 0;
        boolean bl3 = bl = string3 != null && string3.length() > 0;
        if (bl2) {
            if (bl) {
                return new NameTransformer(){

                    @Override
                    public String transform(String string22) {
                        return string2 + string22 + string3;
                    }

                    @Override
                    public String reverse(String string22) {
                        String string32;
                        if (string22.startsWith(string2) && (string32 = string22.substring(string2.length())).endsWith(string3)) {
                            return string32.substring(0, string32.length() - string3.length());
                        }
                        return null;
                    }

                    public String toString() {
                        return "[PreAndSuffixTransformer('" + string2 + "','" + string3 + "')]";
                    }
                };
            }
            return new NameTransformer(){

                @Override
                public String transform(String string22) {
                    return string2 + string22;
                }

                @Override
                public String reverse(String string22) {
                    if (string22.startsWith(string2)) {
                        return string22.substring(string2.length());
                    }
                    return null;
                }

                public String toString() {
                    return "[PrefixTransformer('" + string2 + "')]";
                }
            };
        }
        if (bl) {
            return new NameTransformer(){

                @Override
                public String transform(String string2) {
                    return string2 + string3;
                }

                @Override
                public String reverse(String string2) {
                    if (string2.endsWith(string3)) {
                        return string2.substring(0, string2.length() - string3.length());
                    }
                    return null;
                }

                public String toString() {
                    return "[SuffixTransformer('" + string3 + "')]";
                }
            };
        }
        return NOP;
    }

    public static NameTransformer chainedTransformer(NameTransformer nameTransformer, NameTransformer nameTransformer2) {
        return new Chained(nameTransformer, nameTransformer2);
    }

    public abstract String transform(String var1);

    public abstract String reverse(String var1);

    public static class Chained
    extends NameTransformer {
        protected final NameTransformer _t1;
        protected final NameTransformer _t2;

        public Chained(NameTransformer nameTransformer, NameTransformer nameTransformer2) {
            this._t1 = nameTransformer;
            this._t2 = nameTransformer2;
        }

        @Override
        public String transform(String string2) {
            return this._t1.transform(this._t2.transform(string2));
        }

        @Override
        public String reverse(String string2) {
            if ((string2 = this._t1.reverse(string2)) != null) {
                string2 = this._t2.reverse(string2);
            }
            return string2;
        }

        public String toString() {
            return "[ChainedTransformer(" + this._t1 + ", " + this._t2 + ")]";
        }
    }
}

