/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser.multimap;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class GuavaMultimapDeserializer<T extends Multimap<Object, Object>>
extends JsonDeserializer<T>
implements ContextualDeserializer {
    private static final List<String> METHOD_NAMES = ImmutableList.of("copyOf", "create");
    private final MapLikeType type;
    private final KeyDeserializer keyDeserializer;
    private final TypeDeserializer elementTypeDeserializer;
    private final JsonDeserializer<?> elementDeserializer;
    private final Method creatorMethod;

    public GuavaMultimapDeserializer(MapLikeType mapLikeType, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        this(mapLikeType, keyDeserializer, typeDeserializer, jsonDeserializer, GuavaMultimapDeserializer.findTransformer(mapLikeType.getRawClass()));
    }

    public GuavaMultimapDeserializer(MapLikeType mapLikeType, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, Method method) {
        this.type = mapLikeType;
        this.keyDeserializer = keyDeserializer;
        this.elementTypeDeserializer = typeDeserializer;
        this.elementDeserializer = jsonDeserializer;
        this.creatorMethod = method;
    }

    private static Method findTransformer(Class<?> clazz) {
        Method method;
        if (clazz == LinkedListMultimap.class || clazz == ListMultimap.class || clazz == Multimap.class) {
            return null;
        }
        for (String string2 : METHOD_NAMES) {
            try {
                method = clazz.getMethod(string2, Multimap.class);
                if (method == null) continue;
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        for (String string2 : METHOD_NAMES) {
            try {
                method = clazz.getMethod(string2, Multimap.class);
                if (method == null) continue;
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    protected abstract T createMultimap();

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        TypeDeserializer typeDeserializer;
        JsonDeserializer<Object> jsonDeserializer;
        KeyDeserializer keyDeserializer = this.keyDeserializer;
        if (keyDeserializer == null) {
            keyDeserializer = deserializationContext.findKeyDeserializer(this.type.getKeyType(), beanProperty);
        }
        if ((jsonDeserializer = this.elementDeserializer) == null) {
            jsonDeserializer = deserializationContext.findContextualValueDeserializer(this.type.getContentType(), beanProperty);
        }
        if ((typeDeserializer = this.elementTypeDeserializer) != null && beanProperty != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        return this._createContextual(this.type, keyDeserializer, typeDeserializer, jsonDeserializer, this.creatorMethod);
    }

    protected abstract JsonDeserializer<?> _createContextual(MapLikeType var1, KeyDeserializer var2, TypeDeserializer var3, JsonDeserializer var4, Method var5);

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object;
        T t = this.createMultimap();
        this.expect(jsonParser, JsonToken.START_OBJECT);
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            object = this.keyDeserializer != null ? this.keyDeserializer.deserializeKey(jsonParser.getCurrentName(), deserializationContext) : jsonParser.getCurrentName();
            jsonParser.nextToken();
            this.expect(jsonParser, JsonToken.START_ARRAY);
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                Object object2 = jsonParser.getCurrentToken() == JsonToken.VALUE_NULL ? null : (this.elementTypeDeserializer != null ? this.elementDeserializer.deserializeWithType(jsonParser, deserializationContext, this.elementTypeDeserializer) : (Object)this.elementDeserializer.deserialize(jsonParser, deserializationContext));
                t.put((Object)object, object2);
            }
        }
        if (this.creatorMethod == null) {
            return t;
        }
        try {
            object = (Multimap)this.creatorMethod.invoke(null, t);
            return (T)object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JsonMappingException("Could not map to " + this.type, this._peel(invocationTargetException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonMappingException("Could not map to " + this.type, this._peel(illegalArgumentException));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JsonMappingException("Could not map to " + this.type, this._peel(illegalAccessException));
        }
    }

    private void expect(JsonParser jsonParser, JsonToken jsonToken) throws IOException {
        if (jsonParser.getCurrentToken() != jsonToken) {
            throw new JsonMappingException("Expecting " + (Object)((Object)jsonToken) + ", found " + (Object)((Object)jsonParser.getCurrentToken()), jsonParser.getCurrentLocation());
        }
    }

    private Throwable _peel(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }
}

