/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.module.afterburner.asm.ClassWriter;
import com.fasterxml.jackson.module.afterburner.asm.Label;
import com.fasterxml.jackson.module.afterburner.asm.MethodVisitor;
import com.fasterxml.jackson.module.afterburner.asm.Type;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableIntFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableIntMethodProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableLongFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableLongMethodProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableObjectFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableObjectMethodProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableStringFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableStringMethodProperty;
import com.fasterxml.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PropertyMutatorCollector
extends DynamicPropertyAccessorBase {
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private final ArrayList<SettableIntMethodProperty> _intSetters = new ArrayList();
    private final ArrayList<SettableLongMethodProperty> _longSetters = new ArrayList();
    private final ArrayList<SettableStringMethodProperty> _stringSetters = new ArrayList();
    private final ArrayList<SettableObjectMethodProperty> _objectSetters = new ArrayList();
    private final ArrayList<SettableIntFieldProperty> _intFields = new ArrayList();
    private final ArrayList<SettableLongFieldProperty> _longFields = new ArrayList();
    private final ArrayList<SettableStringFieldProperty> _stringFields = new ArrayList();
    private final ArrayList<SettableObjectFieldProperty> _objectFields = new ArrayList();
    private final Class<?> beanClass;
    private final String beanClassName;

    public PropertyMutatorCollector(Class<?> clazz) {
        this.beanClass = clazz;
        this.beanClassName = Type.getInternalName(clazz);
    }

    public SettableIntMethodProperty addIntSetter(SettableBeanProperty settableBeanProperty) {
        return this._add(this._intSetters, new SettableIntMethodProperty(settableBeanProperty, null, this._intSetters.size()));
    }

    public SettableLongMethodProperty addLongSetter(SettableBeanProperty settableBeanProperty) {
        return this._add(this._longSetters, new SettableLongMethodProperty(settableBeanProperty, null, this._longSetters.size()));
    }

    public SettableStringMethodProperty addStringSetter(SettableBeanProperty settableBeanProperty) {
        return this._add(this._stringSetters, new SettableStringMethodProperty(settableBeanProperty, null, this._stringSetters.size()));
    }

    public SettableObjectMethodProperty addObjectSetter(SettableBeanProperty settableBeanProperty) {
        return this._add(this._objectSetters, new SettableObjectMethodProperty(settableBeanProperty, null, this._objectSetters.size()));
    }

    public SettableIntFieldProperty addIntField(SettableBeanProperty settableBeanProperty) {
        return this._add(this._intFields, new SettableIntFieldProperty(settableBeanProperty, null, this._intFields.size()));
    }

    public SettableLongFieldProperty addLongField(SettableBeanProperty settableBeanProperty) {
        return this._add(this._longFields, new SettableLongFieldProperty(settableBeanProperty, null, this._longFields.size()));
    }

    public SettableStringFieldProperty addStringField(SettableBeanProperty settableBeanProperty) {
        return this._add(this._stringFields, new SettableStringFieldProperty(settableBeanProperty, null, this._stringFields.size()));
    }

    public SettableObjectFieldProperty addObjectField(SettableBeanProperty settableBeanProperty) {
        return this._add(this._objectFields, new SettableObjectFieldProperty(settableBeanProperty, null, this._objectFields.size()));
    }

    public boolean isEmpty() {
        return this._intSetters.isEmpty() && this._longSetters.isEmpty() && this._stringSetters.isEmpty() && this._objectSetters.isEmpty() && this._intFields.isEmpty() && this._longFields.isEmpty() && this._stringFields.isEmpty() && this._objectFields.isEmpty();
    }

    public BeanPropertyMutator buildMutator(MyClassLoader myClassLoader) {
        if (myClassLoader == null) {
            myClassLoader = new MyClassLoader(this.beanClass.getClassLoader(), true);
        }
        String string2 = this.beanClass.getName() + "$Access4JacksonDeserializer";
        String string3 = PropertyMutatorCollector.internalClassName(string2);
        Class<?> clazz = null;
        try {
            clazz = myClassLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = this.generateMutatorClass(myClassLoader, string2, string3);
        }
        try {
            return (BeanPropertyMutator)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to generate accessor class '" + string2 + "': " + exception.getMessage(), exception);
        }
    }

    public Class<?> generateMutatorClass(MyClassLoader myClassLoader, String string2, String string3) {
        ClassWriter classWriter = new ClassWriter(1);
        String string4 = PropertyMutatorCollector.internalClassName(BeanPropertyMutator.class.getName());
        classWriter.visit(49, 33, string3, null, string4, null);
        classWriter.visitSource(string2 + ".java", null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, string4, "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        if (!this._intFields.isEmpty()) {
            this._addFields(classWriter, this._intFields, "intField", Type.INT_TYPE, 21);
        }
        if (!this._longFields.isEmpty()) {
            this._addFields(classWriter, this._longFields, "longField", Type.LONG_TYPE, 22);
        }
        if (!this._stringFields.isEmpty()) {
            this._addFields(classWriter, this._stringFields, "stringField", STRING_TYPE, 25);
        }
        if (!this._objectFields.isEmpty()) {
            this._addFields(classWriter, this._objectFields, "objectField", OBJECT_TYPE, 25);
        }
        if (!this._intSetters.isEmpty()) {
            this._addSetters(classWriter, this._intSetters, "intSetter", Type.INT_TYPE, 21);
        }
        if (!this._longSetters.isEmpty()) {
            this._addSetters(classWriter, this._longSetters, "longSetter", Type.LONG_TYPE, 22);
        }
        if (!this._stringSetters.isEmpty()) {
            this._addSetters(classWriter, this._stringSetters, "stringSetter", STRING_TYPE, 25);
        }
        if (!this._objectSetters.isEmpty()) {
            this._addSetters(classWriter, this._objectSetters, "objectSetter", OBJECT_TYPE, 25);
        }
        classWriter.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        return myClassLoader.loadAndResolve(string2, byArray);
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addSetters(ClassWriter classWriter, List<T> list2, String string2, Type type, int n) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, "(Ljava/lang/Object;I" + type + ")V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, this.beanClassName);
        int n2 = 4 + (type.equals(Type.LONG_TYPE) ? 1 : 0);
        methodVisitor.visitVarInsn(58, n2);
        boolean bl = type.equals(OBJECT_TYPE);
        if (list2.size() <= 4) {
            this._addSettersUsingIf(methodVisitor, list2, n, n2, bl);
        } else {
            this._addSettersUsingSwitch(methodVisitor, list2, n, n2, bl);
        }
        PropertyMutatorCollector.generateException(methodVisitor, this.beanClassName, list2.size());
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addFields(ClassWriter classWriter, List<T> list2, String string2, Type type, int n) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, "(Ljava/lang/Object;I" + type + ")V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, this.beanClassName);
        int n2 = 4 + (type.equals(Type.LONG_TYPE) ? 1 : 0);
        methodVisitor.visitVarInsn(58, n2);
        boolean bl = type.equals(OBJECT_TYPE);
        if (list2.size() < 4) {
            this._addFieldsUsingIf(methodVisitor, list2, n, n2, bl);
        } else {
            this._addFieldsUsingSwitch(methodVisitor, list2, n, n2, bl);
        }
        PropertyMutatorCollector.generateException(methodVisitor, this.beanClassName, list2.size());
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addSettersUsingIf(MethodVisitor methodVisitor, List<T> list2, int n, int n2, boolean bl) {
        methodVisitor.visitVarInsn(21, 2);
        Label label = new Label();
        methodVisitor.visitJumpInsn(154, label);
        methodVisitor.visitVarInsn(25, n2);
        methodVisitor.visitVarInsn(n, 3);
        Method method = (Method)((OptimizedSettableBeanProperty)list2.get(0)).getMember().getMember();
        Type type = Type.getType(method.getParameterTypes()[0]);
        if (bl) {
            methodVisitor.visitTypeInsn(192, type.getInternalName());
        }
        Type type2 = Type.getType(method.getReturnType());
        methodVisitor.visitMethodInsn(182, this.beanClassName, method.getName(), "(" + type + ")" + type2);
        methodVisitor.visitInsn(177);
        int n3 = list2.size();
        for (int i = 1; i < n3; ++i) {
            methodVisitor.visitLabel(label);
            label = new Label();
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitInsn(ALL_INT_CONSTS[i]);
            methodVisitor.visitJumpInsn(160, label);
            methodVisitor.visitVarInsn(25, n2);
            methodVisitor.visitVarInsn(n, 3);
            method = (Method)((OptimizedSettableBeanProperty)list2.get(i)).getMember().getMember();
            type = Type.getType(method.getParameterTypes()[0]);
            type2 = Type.getType(method.getReturnType());
            if (bl) {
                methodVisitor.visitTypeInsn(192, type.getInternalName());
            }
            methodVisitor.visitMethodInsn(182, this.beanClassName, method.getName(), "(" + type + ")" + type2);
            methodVisitor.visitInsn(177);
        }
        methodVisitor.visitLabel(label);
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addSettersUsingSwitch(MethodVisitor methodVisitor, List<T> list2, int n, int n2, boolean bl) {
        methodVisitor.visitVarInsn(21, 2);
        Label[] labelArray = new Label[list2.size()];
        int n3 = labelArray.length;
        for (int i = 0; i < n3; ++i) {
            labelArray[i] = new Label();
        }
        Label label = new Label();
        methodVisitor.visitTableSwitchInsn(0, labelArray.length - 1, label, labelArray);
        int n4 = labelArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            methodVisitor.visitLabel(labelArray[n3]);
            methodVisitor.visitVarInsn(25, n2);
            methodVisitor.visitVarInsn(n, 3);
            Method method = (Method)((OptimizedSettableBeanProperty)list2.get(n3)).getMember().getMember();
            Type type = Type.getType(method.getParameterTypes()[0]);
            Type type2 = Type.getType(method.getReturnType());
            if (bl) {
                methodVisitor.visitTypeInsn(192, type.getInternalName());
            }
            methodVisitor.visitMethodInsn(182, this.beanClassName, method.getName(), "(" + type + ")" + type2);
            methodVisitor.visitInsn(177);
        }
        methodVisitor.visitLabel(label);
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addFieldsUsingIf(MethodVisitor methodVisitor, List<T> list2, int n, int n2, boolean bl) {
        methodVisitor.visitVarInsn(21, 2);
        Label label = new Label();
        methodVisitor.visitJumpInsn(154, label);
        methodVisitor.visitVarInsn(25, n2);
        methodVisitor.visitVarInsn(n, 3);
        AnnotatedField annotatedField = (AnnotatedField)((OptimizedSettableBeanProperty)list2.get(0)).getMember();
        Type type = Type.getType(annotatedField.getRawType());
        if (bl) {
            methodVisitor.visitTypeInsn(192, type.getInternalName());
        }
        methodVisitor.visitFieldInsn(181, this.beanClassName, annotatedField.getName(), type.getDescriptor());
        methodVisitor.visitInsn(177);
        int n3 = list2.size();
        for (int i = 1; i < n3; ++i) {
            methodVisitor.visitLabel(label);
            label = new Label();
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitInsn(ALL_INT_CONSTS[i]);
            methodVisitor.visitJumpInsn(160, label);
            methodVisitor.visitVarInsn(25, n2);
            methodVisitor.visitVarInsn(n, 3);
            annotatedField = (AnnotatedField)((OptimizedSettableBeanProperty)list2.get(i)).getMember();
            type = Type.getType(annotatedField.getRawType());
            if (bl) {
                methodVisitor.visitTypeInsn(192, type.getInternalName());
            }
            methodVisitor.visitFieldInsn(181, this.beanClassName, annotatedField.getName(), type.getDescriptor());
            methodVisitor.visitInsn(177);
        }
        methodVisitor.visitLabel(label);
    }

    private <T extends OptimizedSettableBeanProperty<T>> void _addFieldsUsingSwitch(MethodVisitor methodVisitor, List<T> list2, int n, int n2, boolean bl) {
        methodVisitor.visitVarInsn(21, 2);
        Label[] labelArray = new Label[list2.size()];
        int n3 = labelArray.length;
        for (int i = 0; i < n3; ++i) {
            labelArray[i] = new Label();
        }
        Label label = new Label();
        methodVisitor.visitTableSwitchInsn(0, labelArray.length - 1, label, labelArray);
        int n4 = labelArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            methodVisitor.visitLabel(labelArray[n3]);
            methodVisitor.visitVarInsn(25, n2);
            methodVisitor.visitVarInsn(n, 3);
            AnnotatedField annotatedField = (AnnotatedField)((OptimizedSettableBeanProperty)list2.get(n3)).getMember();
            Type type = Type.getType(annotatedField.getRawType());
            if (bl) {
                methodVisitor.visitTypeInsn(192, type.getInternalName());
            }
            methodVisitor.visitFieldInsn(181, this.beanClassName, annotatedField.getName(), type.getDescriptor());
            methodVisitor.visitInsn(177);
        }
        methodVisitor.visitLabel(label);
    }
}

