/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class LongMethodPropertyWriter
extends OptimizedBeanPropertyWriter<LongMethodPropertyWriter> {
    private final long _suppressableLong;
    private final boolean _suppressableLongSet;

    public LongMethodPropertyWriter(BeanPropertyWriter beanPropertyWriter, BeanPropertyAccessor beanPropertyAccessor, int n, JsonSerializer<Object> jsonSerializer) {
        super(beanPropertyWriter, beanPropertyAccessor, n, jsonSerializer);
        if (this._suppressableValue != null && this._suppressableValue instanceof Long) {
            this._suppressableLong = (Long)this._suppressableValue;
            this._suppressableLongSet = true;
        } else {
            this._suppressableLong = 0L;
            this._suppressableLongSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> jsonSerializer) {
        return new LongMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, jsonSerializer);
    }

    @Override
    public LongMethodPropertyWriter withAccessor(BeanPropertyAccessor beanPropertyAccessor) {
        if (beanPropertyAccessor == null) {
            throw new IllegalArgumentException();
        }
        return new LongMethodPropertyWriter(this, beanPropertyAccessor, this._propertyIndex, this._serializer);
    }

    @Override
    public void unsafeSerializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        long l = this._propertyAccessor.longGetter(object, this._propertyIndex);
        if (!this._suppressableLongSet || this._suppressableLong != l) {
            jsonGenerator.writeFieldName(this._name);
            jsonGenerator.writeNumber(l);
        }
    }
}

