/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.module.mrbean.BeanBuilder;
import com.fasterxml.jackson.module.mrbean.PackageVersion;
import com.fasterxml.jackson.module.mrbean.TypeBuilder;
import java.lang.reflect.Modifier;

public class AbstractTypeMaterializer
extends AbstractTypeResolver
implements Versioned {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    public static final String DEFAULT_PACKAGE_FOR_GENERATED = "org.codehaus.jackson.generated.";
    protected final MyClassLoader _classLoader;
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected String _defaultPackage = "org.codehaus.jackson.generated.";

    public AbstractTypeMaterializer() {
        this(null);
    }

    public AbstractTypeMaterializer(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this._classLoader = new MyClassLoader(classLoader);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._featureFlags & feature.getMask()) != 0;
    }

    public void enable(Feature feature) {
        this._featureFlags |= feature.getMask();
    }

    public void disable(Feature feature) {
        this._featureFlags &= ~feature.getMask();
    }

    public void set(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
    }

    public void setDefaultPackage(String string2) {
        if (!string2.endsWith(".")) {
            string2 = string2 + ".";
        }
        this._defaultPackage = string2;
    }

    @Override
    public JavaType resolveAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) {
        if (javaType.isContainerType() || javaType.isPrimitive() || javaType.isEnumType() || javaType.isThrowable()) {
            return null;
        }
        Class<?> clazz = javaType.getRawClass();
        if (!Modifier.isPublic(clazz.getModifiers())) {
            if (this.isEnabled(Feature.FAIL_ON_NON_PUBLIC_TYPES)) {
                throw new IllegalArgumentException("Can not materialize implementation of " + clazz + " since it is not public ");
            }
            return null;
        }
        return deserializationConfig.constructType(this.materializeClass(deserializationConfig, javaType));
    }

    public Class<?> materializeClass(DeserializationConfig deserializationConfig, JavaType javaType) {
        byte[] byArray;
        Object object;
        String string2;
        Class<?> clazz;
        if (javaType.containedTypeCount() > 0) {
            clazz = javaType.getRawClass();
            string2 = this._defaultPackage + "abstract." + clazz.getName() + "_TYPE_RESOLVE";
            object = new TypeBuilder(javaType);
            byArray = ((TypeBuilder)object).buildAbstractBase(string2);
            Class<?> clazz2 = this._classLoader.loadAndResolve(string2, byArray, clazz);
            javaType = deserializationConfig.getTypeFactory().constructType(clazz2);
        }
        clazz = javaType.getRawClass();
        string2 = this._defaultPackage + clazz.getName();
        object = new BeanBuilder(clazz, deserializationConfig.getTypeFactory());
        byArray = ((BeanBuilder)object).implement(this.isEnabled(Feature.FAIL_ON_UNMATERIALIZED_METHOD)).build(string2);
        return this._classLoader.loadAndResolve(string2, byArray, clazz);
    }

    private static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class<?> loadAndResolve(String string2, byte[] byArray, Class<?> clazz) throws IllegalArgumentException {
            Class<?> clazz2;
            Class<?> clazz3 = this.findLoadedClass(string2);
            if (clazz3 != null && clazz.isAssignableFrom(clazz3)) {
                return clazz3;
            }
            try {
                clazz2 = this.defineClass(string2, byArray, 0, byArray.length);
            }
            catch (LinkageError linkageError) {
                throw new IllegalArgumentException("Failed to load class '" + string2 + "': " + linkageError.getMessage(), linkageError);
            }
            this.resolveClass(clazz2);
            return clazz2;
        }
    }

    public static enum Feature {
        FAIL_ON_UNMATERIALIZED_METHOD(false),
        FAIL_ON_NON_PUBLIC_TYPES(true);

        final boolean _defaultState;

        protected static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

