/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.mrbean.BeanUtil;
import com.fasterxml.jackson.module.mrbean.POJOProperty;
import com.fasterxml.jackson.module.mrbean.asm.ClassWriter;
import com.fasterxml.jackson.module.mrbean.asm.FieldVisitor;
import com.fasterxml.jackson.module.mrbean.asm.MethodVisitor;
import com.fasterxml.jackson.module.mrbean.asm.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class BeanBuilder {
    protected Map<String, POJOProperty> _beanProperties = new LinkedHashMap<String, POJOProperty>();
    protected LinkedHashMap<String, Method> _unsupportedMethods = new LinkedHashMap();
    protected final Class<?> _implementedType;
    protected final TypeFactory _typeFactory;

    public BeanBuilder(Class<?> clazz, TypeFactory typeFactory) {
        this._implementedType = clazz;
        this._typeFactory = typeFactory;
    }

    public BeanBuilder implement(boolean bl) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(this._implementedType);
        BeanUtil.findSuperTypes(this._implementedType, Object.class, arrayList);
        for (Class<?> clazz : arrayList) {
            for (Method method : clazz.getDeclaredMethods()) {
                String string2 = method.getName();
                int n = method.getParameterTypes().length;
                if (n == 0) {
                    if (string2.startsWith("get") || string2.startsWith("is") && BeanBuilder.returnsBoolean(method)) {
                        this.addGetter(method);
                        continue;
                    }
                } else if (n == 1 && string2.startsWith("set")) {
                    this.addSetter(method);
                    continue;
                }
                if (BeanUtil.isConcrete(method) || this._unsupportedMethods.containsKey(string2)) continue;
                if (bl) {
                    throw new IllegalArgumentException("Unrecognized abstract method '" + string2 + "' (not a getter or setter) -- to avoid exception, disable AbstractTypeMaterializer.Feature.FAIL_ON_UNMATERIALIZED_METHOD");
                }
                this._unsupportedMethods.put(string2, method);
            }
        }
        return this;
    }

    public byte[] build(String string2) {
        String string3;
        ClassWriter classWriter = new ClassWriter(1);
        String string4 = BeanBuilder.getInternalClassName(string2);
        String string5 = BeanBuilder.getInternalClassName(this._implementedType.getName());
        if (this._implementedType.isInterface()) {
            string3 = "java/lang/Object";
            classWriter.visit(49, 33, string4, null, string3, new String[]{string5});
        } else {
            string3 = string5;
            classWriter.visit(49, 33, string4, null, string5, null);
        }
        classWriter.visitSource(string2 + ".java", null);
        BeanBuilder.generateDefaultConstructor(classWriter, string3);
        for (POJOProperty object : this._beanProperties.values()) {
            TypeDescription typeDescription = object.selectType(this._typeFactory);
            BeanBuilder.createField(classWriter, object, typeDescription);
            if (!object.hasConcreteGetter()) {
                BeanBuilder.createGetter(classWriter, string4, object, typeDescription);
            }
            if (object.hasConcreteSetter()) continue;
            BeanBuilder.createSetter(classWriter, string4, object, typeDescription);
        }
        for (Method method : this._unsupportedMethods.values()) {
            BeanBuilder.createUnimplementedMethod(classWriter, string4, method);
        }
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static String getPropertyName(String string2) {
        int n = string2.startsWith("is") ? 2 : 3;
        String string3 = string2.substring(n);
        StringBuilder stringBuilder = new StringBuilder(string3);
        stringBuilder.setCharAt(0, Character.toLowerCase(string3.charAt(0)));
        return stringBuilder.toString();
    }

    private static String buildGetterName(String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        return stringBuilder.append("get").append(Character.toUpperCase(string2.charAt(0))).append(string2.substring(1)).toString();
    }

    private static String buildSetterName(String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        return stringBuilder.append("set").append(Character.toUpperCase(string2.charAt(0))).append(string2.substring(1)).toString();
    }

    private static String getInternalClassName(String string2) {
        return string2.replace(".", "/");
    }

    private void addGetter(Method method) {
        POJOProperty pOJOProperty = this.findProperty(BeanBuilder.getPropertyName(method.getName()));
        if (pOJOProperty.getGetter() == null) {
            pOJOProperty.setGetter(method);
        }
    }

    private void addSetter(Method method) {
        POJOProperty pOJOProperty = this.findProperty(BeanBuilder.getPropertyName(method.getName()));
        if (pOJOProperty.getSetter() == null) {
            pOJOProperty.setSetter(method);
        }
    }

    private POJOProperty findProperty(String string2) {
        POJOProperty pOJOProperty = this._beanProperties.get(string2);
        if (pOJOProperty == null) {
            pOJOProperty = new POJOProperty(string2, this._implementedType);
            this._beanProperties.put(string2, pOJOProperty);
        }
        return pOJOProperty;
    }

    private static final boolean returnsBoolean(Method method) {
        Class<?> clazz = method.getReturnType();
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    protected static void generateDefaultConstructor(ClassWriter classWriter, String string2) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, string2, "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void createField(ClassWriter classWriter, POJOProperty pOJOProperty, TypeDescription typeDescription) {
        String string2 = typeDescription.hasGenerics() ? typeDescription.genericSignature() : null;
        String string3 = typeDescription.erasedSignature();
        FieldVisitor fieldVisitor = classWriter.visitField(1, pOJOProperty.getFieldName(), string3, string2, null);
        fieldVisitor.visitEnd();
    }

    private static void createSetter(ClassWriter classWriter, String string2, POJOProperty pOJOProperty, TypeDescription typeDescription) {
        String string3;
        String string4;
        Method method = pOJOProperty.getSetter();
        if (method != null) {
            string4 = Type.getMethodDescriptor(method);
            string3 = method.getName();
        } else {
            string4 = "(" + typeDescription.erasedSignature() + ")V";
            string3 = BeanBuilder.buildSetterName(pOJOProperty.getName());
        }
        String string5 = typeDescription.hasGenerics() ? "(" + typeDescription.genericSignature() + ")V" : null;
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string3, string4, string5, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(typeDescription.getLoadOpcode(), 1);
        methodVisitor.visitFieldInsn(181, string2, pOJOProperty.getFieldName(), typeDescription.erasedSignature());
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void createGetter(ClassWriter classWriter, String string2, POJOProperty pOJOProperty, TypeDescription typeDescription) {
        String string3;
        String string4;
        Method method = pOJOProperty.getGetter();
        if (method != null) {
            string4 = Type.getMethodDescriptor(method);
            string3 = method.getName();
        } else {
            string4 = "()" + typeDescription.erasedSignature();
            string3 = BeanBuilder.buildGetterName(pOJOProperty.getName());
        }
        String string5 = typeDescription.hasGenerics() ? "()" + typeDescription.genericSignature() : null;
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string3, string4, string5, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, string2, pOJOProperty.getFieldName(), typeDescription.erasedSignature());
        methodVisitor.visitInsn(typeDescription.getReturnOpcode());
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void createUnimplementedMethod(ClassWriter classWriter, String string2, Method method) {
        String string3 = BeanBuilder.getInternalClassName(UnsupportedOperationException.class.getName());
        String string4 = Type.getMethodDescriptor(method);
        String string5 = method.getName();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string5, string4, null, null);
        methodVisitor.visitTypeInsn(187, string3);
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn("Unimplemented method '" + string5 + "' (not a setter/getter, could not materialize)");
        methodVisitor.visitMethodInsn(183, string3, "<init>", "(Ljava/lang/String;)V");
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    static class TypeDescription {
        private final Type _asmType;
        private JavaType _jacksonType;

        public TypeDescription(JavaType javaType) {
            this._jacksonType = javaType;
            this._asmType = Type.getType(javaType.getRawClass());
        }

        public Class<?> getRawClass() {
            return this._jacksonType.getRawClass();
        }

        public String erasedSignature() {
            return this._jacksonType.getErasedSignature();
        }

        public String genericSignature() {
            return this._jacksonType.getGenericSignature();
        }

        public boolean hasGenerics() {
            return this._jacksonType.hasGenericTypes();
        }

        public int getLoadOpcode() {
            return this._asmType.getOpcode(21);
        }

        public int getReturnOpcode() {
            return this._asmType.getOpcode(172);
        }

        public String toString() {
            return this._jacksonType.toString();
        }

        public static TypeDescription moreSpecificType(TypeDescription typeDescription, TypeDescription typeDescription2) {
            Class<?> clazz;
            Class<?> clazz2 = typeDescription.getRawClass();
            if (clazz2.isAssignableFrom(clazz = typeDescription2.getRawClass())) {
                return typeDescription2;
            }
            if (clazz.isAssignableFrom(clazz2)) {
                return typeDescription;
            }
            return null;
        }
    }
}

