/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.base.Objects;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.multibindings.Element;
import com.google.inject.multibindings.MultibinderBinding;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.multibindings.RealElement;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Multibinder<T> {
    private Multibinder() {
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type) {
        binder = binder.skipSources(RealMultibinder.class, Multibinder.class);
        RealMultibinder result2 = new RealMultibinder(binder, type, Key.get(Multibinder.setOf(type)));
        binder.install(result2);
        return result2;
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type) {
        return Multibinder.newSetBinder(binder, TypeLiteral.get(type));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type, Annotation annotation) {
        binder = binder.skipSources(RealMultibinder.class, Multibinder.class);
        RealMultibinder result2 = new RealMultibinder(binder, type, Key.get(Multibinder.setOf(type), annotation));
        binder.install(result2);
        return result2;
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type, Annotation annotation) {
        return Multibinder.newSetBinder(binder, TypeLiteral.get(type), annotation);
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type, Class<? extends Annotation> annotationType) {
        binder = binder.skipSources(RealMultibinder.class, Multibinder.class);
        RealMultibinder result2 = new RealMultibinder(binder, type, Key.get(Multibinder.setOf(type), annotationType));
        binder.install(result2);
        return result2;
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type, Class<? extends Annotation> annotationType) {
        return Multibinder.newSetBinder(binder, TypeLiteral.get(type), annotationType);
    }

    static <T> TypeLiteral<Set<T>> setOf(TypeLiteral<T> elementType) {
        ParameterizedType type = Types.setOf(elementType.getType());
        return TypeLiteral.get(type);
    }

    public abstract Multibinder<T> permitDuplicates();

    public abstract LinkedBindingBuilder<T> addBinding();

    static void checkConfiguration(boolean condition, String format2, Object ... args) {
        if (condition) {
            return;
        }
        throw new ConfigurationException(ImmutableSet.of(new Message(Errors.format(format2, args))));
    }

    private static <T> ConfigurationException newDuplicateValuesException(Map<T, Binding<T>> existingBindings, Binding<T> binding, T newValue, Binding<T> duplicateBinding) {
        String newString;
        T oldValue = Iterables.getOnlyElement(Iterables.filter(existingBindings.keySet(), Predicates.equalTo(newValue)));
        String oldString = oldValue.toString();
        if (Objects.equal(oldString, newString = newValue.toString())) {
            return new ConfigurationException(ImmutableSet.of(new Message(Errors.format("Set injection failed due to duplicated element \"%s\"\n    Bound at %s\n    Bound at %s", newValue, duplicateBinding.getSource(), binding.getSource()))));
        }
        return new ConfigurationException(ImmutableSet.of(new Message(Errors.format("Set injection failed due to multiple elements comparing equal:\n    \"%s\"\n        bound at %s\n    \"%s\"\n        bound at %s", oldValue, duplicateBinding.getSource(), newValue, binding.getSource()))));
    }

    static <T> T checkNotNull(T reference, String name) {
        if (reference != null) {
            return reference;
        }
        NullPointerException npe = new NullPointerException(name);
        throw new ConfigurationException(ImmutableSet.of(new Message(npe.toString(), npe)));
    }

    private static class PermitDuplicatesModule
    extends AbstractModule {
        private final Key<Boolean> key;

        PermitDuplicatesModule(Key<Boolean> key) {
            this.key = key;
        }

        @Override
        protected void configure() {
            this.bind(this.key).toInstance(true);
        }

        public boolean equals(Object o) {
            return o instanceof PermitDuplicatesModule && ((PermitDuplicatesModule)o).key.equals(this.key);
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ this.key.hashCode();
        }
    }

    static final class RealMultibinder<T>
    extends Multibinder<T>
    implements Module,
    ProviderWithExtensionVisitor<Set<T>>,
    HasDependencies,
    MultibinderBinding<Set<T>> {
        private final TypeLiteral<T> elementType;
        private final String setName;
        private final Key<Set<T>> setKey;
        private final Key<Boolean> permitDuplicatesKey;
        private Binder binder;
        private ImmutableList<Binding<T>> bindings;
        private Set<Dependency<?>> dependencies;
        private boolean permitDuplicates;

        private RealMultibinder(Binder binder, TypeLiteral<T> elementType, Key<Set<T>> setKey) {
            this.binder = RealMultibinder.checkNotNull(binder, "binder");
            this.elementType = RealMultibinder.checkNotNull(elementType, "elementType");
            this.setKey = RealMultibinder.checkNotNull(setKey, "setKey");
            this.setName = RealMultibinder.nameOf(setKey);
            this.permitDuplicatesKey = Key.get(Boolean.class, (Annotation)Names.named(this.toString() + " permits duplicates"));
        }

        private static String nameOf(Key<?> setKey) {
            Annotation annotation = setKey.getAnnotation();
            Class<Annotation> annotationType = setKey.getAnnotationType();
            if (annotation != null && !Annotations.isMarker(annotationType)) {
                return ((Object)setKey.getAnnotation()).toString();
            }
            if (setKey.getAnnotationType() != null) {
                return "@" + setKey.getAnnotationType().getName();
            }
            return "";
        }

        @Override
        public void configure(Binder binder) {
            RealMultibinder.checkConfiguration(!this.isInitialized(), "Multibinder was already initialized", new Object[0]);
            binder.bind(this.setKey).toProvider(this);
        }

        @Override
        public Multibinder<T> permitDuplicates() {
            this.binder.install(new PermitDuplicatesModule(this.permitDuplicatesKey));
            return this;
        }

        @Override
        public LinkedBindingBuilder<T> addBinding() {
            RealMultibinder.checkConfiguration(!this.isInitialized(), "Multibinder was already initialized", new Object[0]);
            return RealElement.addBinding(this.binder, Element.Type.MULTIBINDER, this.elementType, this.setName);
        }

        @Toolable
        @Inject
        void initialize(Injector injector) {
            ArrayList<Binding<T>> bindings = Lists.newArrayList();
            ArrayList<Dependency<T>> dependencies = Lists.newArrayList();
            for (Binding<T> entry : injector.findBindingsByType(this.elementType)) {
                if (!this.keyMatches(entry.getKey())) continue;
                Binding<T> binding = entry;
                bindings.add(binding);
                dependencies.add(Dependency.get(binding.getKey()));
            }
            this.bindings = ImmutableList.copyOf(bindings);
            this.dependencies = ImmutableSet.copyOf(dependencies);
            this.permitDuplicates = this.permitsDuplicates(injector);
            this.binder = null;
        }

        boolean permitsDuplicates(Injector injector) {
            return injector.getBindings().containsKey(this.permitDuplicatesKey);
        }

        private boolean keyMatches(Key<?> key) {
            return key.getTypeLiteral().equals(this.elementType) && key.getAnnotation() instanceof Element && ((Element)key.getAnnotation()).setName().equals(this.setName) && ((Element)key.getAnnotation()).type() == Element.Type.MULTIBINDER;
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        @Override
        public Set<T> get() {
            RealMultibinder.checkConfiguration(this.isInitialized(), "Multibinder is not initialized", new Object[0]);
            LinkedHashMap result2 = new LinkedHashMap();
            for (Binding binding : this.bindings) {
                Object newValue = binding.getProvider().get();
                RealMultibinder.checkConfiguration(newValue != null, "Set injection failed due to null element", new Object[0]);
                Binding duplicateBinding = result2.put(newValue, binding);
                if (this.permitDuplicates || duplicateBinding == null) continue;
                throw Multibinder.newDuplicateValuesException(result2, binding, newValue, duplicateBinding);
            }
            return ImmutableSet.copyOf(result2.keySet());
        }

        @Override
        public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
            if (visitor instanceof MultibindingsTargetVisitor) {
                return ((MultibindingsTargetVisitor)visitor).visit(this);
            }
            return visitor.visit(binding);
        }

        String getSetName() {
            return this.setName;
        }

        @Override
        public TypeLiteral<?> getElementTypeLiteral() {
            return this.elementType;
        }

        @Override
        public Key<Set<T>> getSetKey() {
            return this.setKey;
        }

        @Override
        public List<Binding<?>> getElements() {
            if (this.isInitialized()) {
                return this.bindings;
            }
            throw new UnsupportedOperationException("getElements() not supported for module bindings");
        }

        @Override
        public boolean permitsDuplicates() {
            if (this.isInitialized()) {
                return this.permitDuplicates;
            }
            throw new UnsupportedOperationException("permitsDuplicates() not supported for module bindings");
        }

        @Override
        public boolean containsElement(com.google.inject.spi.Element element) {
            if (element instanceof Binding) {
                Binding binding = (Binding)element;
                return this.keyMatches(binding.getKey()) || binding.getKey().equals(this.permitDuplicatesKey) || binding.getKey().equals(this.setKey);
            }
            return false;
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            if (!this.isInitialized()) {
                return ImmutableSet.of(Dependency.get(Key.get(Injector.class)));
            }
            return this.dependencies;
        }

        public boolean equals(Object o) {
            return o instanceof RealMultibinder && ((RealMultibinder)o).setKey.equals(this.setKey);
        }

        public int hashCode() {
            return this.setKey.hashCode();
        }

        public String toString() {
            return this.setName + (this.setName.length() > 0 ? " " : "") + "Multibinder<" + this.elementType + ">";
        }
    }
}

