/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.ServletDefinition;
import com.google.inject.servlet.ServletModule;
import com.google.inject.servlet.UriPatternType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;

class ServletsModuleBuilder {
    private final Set<String> servletUris = Sets.newHashSet();
    private final Binder binder;

    public ServletsModuleBuilder(Binder binder) {
        this.binder = binder;
    }

    public ServletModule.ServletKeyBindingBuilder serve(List<String> urlPatterns) {
        return new ServletKeyBindingBuilderImpl(urlPatterns, UriPatternType.SERVLET);
    }

    public ServletModule.ServletKeyBindingBuilder serveRegex(List<String> regexes) {
        return new ServletKeyBindingBuilderImpl(regexes, UriPatternType.REGEX);
    }

    class ServletKeyBindingBuilderImpl
    implements ServletModule.ServletKeyBindingBuilder {
        private final List<String> uriPatterns;
        private final UriPatternType uriPatternType;

        private ServletKeyBindingBuilderImpl(List<String> uriPatterns, UriPatternType uriPatternType) {
            this.uriPatterns = uriPatterns;
            this.uriPatternType = uriPatternType;
        }

        @Override
        public void with(Class<? extends HttpServlet> servletKey) {
            this.with(Key.get(servletKey));
        }

        @Override
        public void with(Key<? extends HttpServlet> servletKey) {
            this.with(servletKey, new HashMap<String, String>());
        }

        @Override
        public void with(HttpServlet servlet) {
            this.with(servlet, new HashMap<String, String>());
        }

        @Override
        public void with(Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(Key.get(servletKey), initParams);
        }

        @Override
        public void with(Key<? extends HttpServlet> servletKey, Map<String, String> initParams) {
            this.with(servletKey, initParams, null);
        }

        private void with(Key<? extends HttpServlet> servletKey, Map<String, String> initParams, HttpServlet servletInstance) {
            for (String pattern : this.uriPatterns) {
                if (!ServletsModuleBuilder.this.servletUris.add(pattern)) {
                    ServletsModuleBuilder.this.binder.addError("More than one servlet was mapped to the same URI pattern: " + pattern, new Object[0]);
                    continue;
                }
                ServletsModuleBuilder.this.binder.bind(Key.get(ServletDefinition.class, UniqueAnnotations.create())).toProvider(new ServletDefinition(pattern, servletKey, UriPatternType.get(this.uriPatternType, pattern), initParams, servletInstance));
            }
        }

        @Override
        public void with(HttpServlet servlet, Map<String, String> initParams) {
            Key<HttpServlet> servletKey = Key.get(HttpServlet.class, UniqueAnnotations.create());
            ServletsModuleBuilder.this.binder.bind(servletKey).toInstance(servlet);
            this.with(servletKey, initParams, servlet);
        }
    }
}

