/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.callback;

import com.nesscomputing.callback.BatchingCallback;
import com.nesscomputing.callback.BatchingCallbackExecutionException;
import com.nesscomputing.callback.Callback;
import com.nesscomputing.callback.CallbackRefusedException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

class ExecutorBatchingCallback<T>
extends BatchingCallback<T> {
    ExecutorBatchingCallback(int size2, ExecutorService executor, Callback<? super List<T>> out, boolean failFast) {
        super(size2, new ExecutorCallback(executor, out, failFast));
    }

    @Override
    public boolean commit() {
        boolean result2 = super.commit();
        ((ExecutorCallback)ExecutorCallback.class.cast(this.getOut())).close();
        return result2;
    }

    static class ExecutorCallable<T>
    implements Callable<Void> {
        private final Callback<? super List<T>> out;
        private final List<T> item;

        ExecutorCallable(Callback<? super List<T>> out, List<T> item) {
            this.out = out;
            this.item = item;
        }

        @Override
        public Void call() throws Exception {
            this.out.call(this.item);
            return null;
        }
    }

    static class ExecutorCallback<T>
    implements Callback<List<T>> {
        private final ExecutorCompletionService<Void> executor;
        private final Callback<? super List<T>> out;
        private final AtomicLong inFlight = new AtomicLong();
        private final BatchingCallbackExecutionException exceptions = new BatchingCallbackExecutionException();
        private final AtomicBoolean failed = new AtomicBoolean();
        private final boolean failFast;

        ExecutorCallback(ExecutorService executor, Callback<? super List<T>> out, boolean failFast) {
            this.executor = new ExecutorCompletionService(executor);
            this.out = out;
            this.failFast = failFast;
        }

        @Override
        public void call(List<T> item) throws Exception {
            Future<Void> f;
            if (this.failed.get()) {
                throw new CallbackRefusedException();
            }
            this.inFlight.incrementAndGet();
            this.executor.submit(new ExecutorCallable<T>(this.out, item));
            while ((f = this.executor.poll()) != null) {
                this.inFlight.decrementAndGet();
                try {
                    f.get();
                }
                catch (ExecutionException e) {
                    this.exceptions.addSuppressed(e.getCause());
                    if (!this.failFast) continue;
                    this.failed.set(true);
                    this.exceptions.fillInStackTrace();
                    throw this.exceptions;
                }
            }
        }

        public void close() {
            while (this.inFlight.decrementAndGet() >= 0L) {
                try {
                    this.executor.take().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
                catch (ExecutionException e) {
                    this.exceptions.addSuppressed(e.getCause());
                }
            }
            if (this.exceptions.getSuppressed().length != 0) {
                this.exceptions.fillInStackTrace();
                throw this.exceptions;
            }
        }
    }
}

