/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.config;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.nesscomputing.config.ConfigFactory;
import com.nesscomputing.config.util.ImmutableConfiguration;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.tree.OverrideCombiner;
import org.skife.config.CommonsConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    private static final Logger LOG = LoggerFactory.getLogger(Config.class);
    public static final String CONFIG_PROPERTY_NAME = "ness.config";
    public static final String CONFIG_LOCATION_PROPERTY_NAME = "ness.config.location";
    private static final Object NULL_OBJECT = new Object();
    private final ConcurrentMap<Object, ConfigurationObjectFactory> objectFactories = Maps.newConcurrentMap();
    private final CombinedConfiguration config;
    private transient String toStringValue = null;

    public static Config getFixedConfig(AbstractConfiguration ... configs) {
        CombinedConfiguration cc = new CombinedConfiguration(new OverrideCombiner());
        if (configs != null) {
            for (AbstractConfiguration config : configs) {
                cc.addConfiguration(config);
            }
        }
        return new Config(cc);
    }

    public static Config getFixedConfig(@Nonnull Map<String, String> config) {
        return Config.getFixedConfig(new MapConfiguration(config));
    }

    public static Config getFixedConfig(String ... keyValuePairs) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        if (keyValuePairs != null) {
            Iterator<String> it = Arrays.asList(keyValuePairs).iterator();
            while (it.hasNext()) {
                String key = it.next();
                if (it.hasNext()) {
                    builder.put(key, it.next());
                    continue;
                }
                LOG.warn("Found an odd number of arguments for key/value pairs. Ignoring key %s", (Object)key);
                break;
            }
        }
        return Config.getFixedConfig(new MapConfiguration(builder.build()));
    }

    public static Config getEmptyConfig() {
        return new Config(new CombinedConfiguration(new OverrideCombiner()));
    }

    public static Config getConfig() {
        SystemConfiguration systemConfig = new SystemConfiguration();
        String configName = systemConfig.getString(CONFIG_PROPERTY_NAME);
        String configLocation = systemConfig.getString(CONFIG_LOCATION_PROPERTY_NAME);
        Preconditions.checkState(configLocation != null, "Config location must be set!");
        ConfigFactory configFactory = new ConfigFactory(URI.create(configLocation), configName);
        return new Config(configFactory.load());
    }

    public static Config getConfig(@Nonnull URI configLocation, @Nullable String configName) {
        ConfigFactory configFactory = new ConfigFactory(configLocation, configName);
        return new Config(configFactory.load());
    }

    public static Config getOverriddenConfig(@Nonnull Config config, AbstractConfiguration ... overrideConfigurations) {
        Object first;
        if (overrideConfigurations == null || overrideConfigurations.length == 0) {
            return config;
        }
        CombinedConfiguration cc = new CombinedConfiguration(new OverrideCombiner());
        int index2 = 0;
        Object object = first = config.config.getNumberOfConfigurations() > 0 ? (AbstractConfiguration)AbstractConfiguration.class.cast(config.config.getConfiguration(index2)) : null;
        if (first != null && first.getClass() == SystemConfiguration.class) {
            cc.addConfiguration((AbstractConfiguration)first);
            ++index2;
        } else {
            for (AbstractConfiguration c : overrideConfigurations) {
                if (c.getClass() != SystemConfiguration.class) continue;
                cc.addConfiguration(c);
            }
        }
        for (AbstractConfiguration c : overrideConfigurations) {
            if (c.getClass() == SystemConfiguration.class) continue;
            cc.addConfiguration(c);
        }
        while (index2 < config.config.getNumberOfConfigurations()) {
            AbstractConfiguration c;
            if ((c = (AbstractConfiguration)AbstractConfiguration.class.cast(config.config.getConfiguration(index2++))).getClass() == SystemConfiguration.class) continue;
            cc.addConfiguration(c);
        }
        return new Config(cc);
    }

    public static Config getConfig(@Nonnull String configLocation, @Nullable String configName) {
        ConfigFactory configFactory = new ConfigFactory(URI.create(configLocation), configName);
        return new Config(configFactory.load());
    }

    private Config(@Nonnull CombinedConfiguration config) {
        this.config = config;
    }

    public AbstractConfiguration getConfiguration() {
        return new ImmutableConfiguration(this.config);
    }

    public AbstractConfiguration getConfiguration(String prefix) {
        return new ImmutableConfiguration(this.config.subset(prefix));
    }

    public <T> T getBean(Class<T> classType) {
        return this.getBean(null, classType, null);
    }

    public <T> T getBean(String prefix, Class<T> classType) {
        return this.getBean(prefix, classType, null);
    }

    public <T> T getBean(Class<T> classType, Map<String, String> replacements) {
        return this.getBean(null, classType, replacements);
    }

    public <T> T getBean(String prefix, Class<T> classType, Map<String, String> replacements) {
        ConfigurationObjectFactory factory = null;
        Object key = Objects.firstNonNull(prefix, NULL_OBJECT);
        factory = (ConfigurationObjectFactory)this.objectFactories.get(key);
        if (factory == null) {
            CombinedConfiguration cfg = prefix == null ? this.config : this.config.subset(prefix);
            factory = new ConfigurationObjectFactory(new CommonsConfigSource(cfg));
            ConfigurationObjectFactory newFactory = this.objectFactories.putIfAbsent(key, factory);
            factory = Objects.firstNonNull(newFactory, factory);
        }
        return factory.buildWithReplacements(classType, replacements);
    }

    public String toString() {
        if (this.config == null) {
            return "<uninitialized>";
        }
        if (this.toStringValue == null) {
            StringBuilder sb = new StringBuilder("[");
            Iterator<String> it = this.config.getKeys();
            while (it.hasNext()) {
                String key = it.next();
                sb.append(key);
                sb.append("->");
                sb.append(this.config.getString(key));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(']');
            this.toStringValue = sb.toString();
        }
        return this.toStringValue;
    }
}

