/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.config;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.nesscomputing.config.util.ClasspathConfigStrategy;
import com.nesscomputing.config.util.ConfigStrategy;
import com.nesscomputing.config.util.FileConfigStrategy;
import com.nesscomputing.config.util.HttpConfigStrategy;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.tree.OverrideCombiner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFactory.class);
    private static final Map<String, ? extends ConfigStrategyProvider> STRATEGY_PROVIDERS = ImmutableMap.of("classpath", new ConfigStrategyProvider(){

        @Override
        public ConfigStrategy getStrategy(URI configLocation) {
            return new ClasspathConfigStrategy(configLocation);
        }
    }, "file", new ConfigStrategyProvider(){

        @Override
        public ConfigStrategy getStrategy(URI configLocation) {
            return new FileConfigStrategy(configLocation);
        }
    }, "http", new ConfigStrategyProvider(){

        @Override
        public ConfigStrategy getStrategy(URI configLocation) {
            return new HttpConfigStrategy(configLocation);
        }
    }, "https", new ConfigStrategyProvider(){

        @Override
        public ConfigStrategy getStrategy(URI configLocation) {
            return new HttpConfigStrategy(configLocation);
        }
    });
    private final String configName;
    private final ConfigStrategy configStrategy;

    ConfigFactory(@Nonnull URI configLocation, @Nullable String configName) {
        this.configName = Objects.firstNonNull(configName, "default");
        this.configStrategy = this.selectConfigStrategy(configLocation);
    }

    CombinedConfiguration load() {
        Object[] configNames = StringUtils.stripAll(StringUtils.split(this.configName, "/:"));
        CombinedConfiguration cc = new CombinedConfiguration(new OverrideCombiner());
        cc.addConfiguration(new SystemConfiguration(), "systemProperties");
        boolean loadedConfig = false;
        for (int i = 0; i < configNames.length; ++i) {
            String configFileName = configNames[configNames.length - i - 1];
            String configFilePath = StringUtils.join(configNames, "/", 0, configNames.length - i);
            try {
                AbstractConfiguration subConfig = this.configStrategy.load(configFileName, configFilePath);
                if (subConfig == null) {
                    LOG.debug("Configuration '%s' does not exist, skipping", (Object)configFileName);
                    continue;
                }
                cc.addConfiguration(subConfig, configFileName);
                loadedConfig = true;
                continue;
            }
            catch (ConfigurationException ce) {
                LOG.error(String.format("While loading configuration '%s'", configFileName), ce);
            }
        }
        if (!loadedConfig && configNames.length > 0) {
            LOG.warn("Config name '%s' was given but no config file could be found, this looks fishy!", (Object)this.configName);
        }
        return cc;
    }

    private ConfigStrategy selectConfigStrategy(URI configLocation) {
        ConfigStrategyProvider configStrategyProvider = STRATEGY_PROVIDERS.get(configLocation.getScheme());
        if (configStrategyProvider == null) {
            throw new IllegalStateException("No strategy for " + configLocation + " available!");
        }
        return configStrategyProvider.getStrategy(configLocation);
    }

    private static interface ConfigStrategyProvider {
        public ConfigStrategy getStrategy(URI var1);
    }
}

