/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.util.Providers;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigJmxExporter;

public class ConfigModule
extends AbstractModule {
    private final Provider<Config> configProvider;

    public static ConfigModule forTesting(String ... keyValuePairs) {
        return new ConfigModule(Config.getFixedConfig(keyValuePairs));
    }

    public static ConfigModule forTesting() {
        return new ConfigModule(Config.getEmptyConfig());
    }

    public ConfigModule() {
        this.configProvider = new Provider<Config>(){

            @Override
            public Config get() {
                return Config.getConfig();
            }
        };
    }

    public ConfigModule(Config config) {
        this.configProvider = Providers.of(config);
    }

    @Deprecated
    public ConfigModule(String ... keyValuePairs) {
        this(Config.getFixedConfig(keyValuePairs));
    }

    @Override
    public void configure() {
        this.bind(Config.class).toProvider(this.configProvider).in(Scopes.SINGLETON);
        this.bind(ConfigJmxExporter.class).asEagerSingleton();
    }
}

