/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.config;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigJmxExporter;
import java.util.Map;
import javax.annotation.Nullable;

public final class ConfigProvider<T>
implements Provider<T> {
    private final String prefix;
    private final Class<T> clazz;
    private final Map<String, String> overrides;
    private volatile T configBean = null;
    private volatile ConfigJmxExporter exporter;

    public static <TYPE> Provider<TYPE> of(Class<TYPE> clazz) {
        return new ConfigProvider<TYPE>(null, clazz, null);
    }

    public static <TYPE> Provider<TYPE> of(@Nullable String prefix, Class<TYPE> clazz) {
        return new ConfigProvider<TYPE>(prefix, clazz, null);
    }

    public static <TYPE> Provider<TYPE> of(@Nullable String prefix, Class<TYPE> clazz, @Nullable Map<String, String> overrides) {
        return new ConfigProvider<TYPE>(prefix, clazz, overrides);
    }

    public static <TYPE> Provider<TYPE> of(Class<TYPE> clazz, @Nullable Map<String, String> overrides) {
        return ConfigProvider.of(null, clazz, overrides);
    }

    private ConfigProvider(String prefix, Class<T> clazz, Map<String, String> overrides) {
        this.prefix = prefix;
        this.clazz = clazz;
        this.overrides = overrides;
    }

    @Inject
    public void setConfig(Config config) {
        this.configBean = config.getBean(this.prefix, this.clazz, this.overrides);
        this.tryExport();
    }

    @Inject(optional=true)
    void setExporter(ConfigJmxExporter exporter) {
        this.exporter = exporter;
        this.tryExport();
    }

    private void tryExport() {
        if (this.exporter != null && this.configBean != null) {
            this.exporter.export(this.clazz, this.configBean);
        }
    }

    @Override
    public T get() {
        Preconditions.checkState(this.configBean != null, "configuration was never injected");
        return this.configBean;
    }
}

