/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.config.util;

import com.nesscomputing.config.util.AbstractConfigStrategy;
import java.io.File;
import java.net.URI;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigStrategy
extends AbstractConfigStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FileConfigStrategy.class);
    private final File directoryLocation;

    public FileConfigStrategy(URI directoryLocationUri) {
        super(directoryLocationUri);
        this.directoryLocation = new File(directoryLocationUri);
        LOG.trace("Searching for configuration at '%s'.", (Object)this.directoryLocation);
    }

    @Override
    public AbstractConfiguration load(String configName, String configPath) throws ConfigurationException {
        File[] propertyFiles;
        if (!(this.directoryLocation.exists() && this.directoryLocation.isDirectory() && this.directoryLocation.canRead())) {
            return null;
        }
        for (File propertyFile : propertyFiles = new File[]{new File(this.directoryLocation, configPath + File.separator + "config.properties"), new File(this.directoryLocation, configName + ".properties")}) {
            if (!propertyFile.exists() || !propertyFile.isFile() || !propertyFile.canRead()) continue;
            LOG.trace("Trying to load '%s'...", (Object)propertyFile);
            try {
                PropertiesConfiguration config = new PropertiesConfiguration(propertyFile);
                LOG.trace("... succeeded");
                return config;
            }
            catch (ConfigurationException ce) {
                LOG.trace("... failed", ce);
            }
        }
        return null;
    }
}

