/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.galaxy;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.nesscomputing.config.Config;
import com.nesscomputing.galaxy.GalaxyDeploy;
import com.nesscomputing.galaxy.GalaxyEnv;
import com.nesscomputing.galaxy.GalaxyGlobal;
import com.nesscomputing.galaxy.GalaxyIp;
import com.nesscomputing.galaxy.GalaxyPrivate;
import javax.annotation.Nonnull;

@Singleton
public class GalaxyConfig {
    private final GalaxyIp internalIp;
    private final GalaxyIp externalIp;
    private final GalaxyDeploy deploy;
    private final GalaxyEnv env;
    private final GalaxyGlobal global;
    private final GalaxyPrivate privat;

    @Inject
    public GalaxyConfig(Config config) {
        this.internalIp = config.getBean("galaxy.internal", GalaxyIp.class);
        this.externalIp = config.getBean("galaxy.external", GalaxyIp.class);
        this.deploy = config.getBean("galaxy.deploy", GalaxyDeploy.class);
        this.env = config.getBean("galaxy.env", GalaxyEnv.class);
        this.global = config.getBean("galaxy.global", GalaxyGlobal.class);
        this.privat = config.getBean("galaxy.private", GalaxyPrivate.class);
    }

    @Nonnull
    public GalaxyIp getInternalIp() {
        return this.internalIp;
    }

    @Nonnull
    public GalaxyIp getExternalIp() {
        return this.externalIp;
    }

    @Nonnull
    public GalaxyDeploy getDeploy() {
        return this.deploy;
    }

    @Nonnull
    public GalaxyEnv getEnv() {
        return this.env;
    }

    @Nonnull
    public GalaxyGlobal getGlobal() {
        return this.global;
    }

    @Nonnull
    public GalaxyPrivate getPrivate() {
        return this.privat;
    }
}

