/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient;

import com.google.common.base.Preconditions;
import com.nesscomputing.httpclient.HttpClientConnectionContext;
import com.nesscomputing.httpclient.HttpClientDefaults;
import com.nesscomputing.httpclient.HttpClientObserver;
import com.nesscomputing.httpclient.HttpClientRequest;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.factory.httpclient4.ApacheHttpClient4Factory;
import com.nesscomputing.httpclient.internal.HttpClientFactory;
import com.nesscomputing.httpclient.internal.HttpClientMethod;
import java.io.Closeable;
import java.net.URI;
import java.util.Set;
import javax.annotation.Nonnull;

public final class HttpClient
implements Closeable {
    private final HttpClientFactory httpClientFactory;

    public HttpClient() {
        this(new HttpClientDefaults());
    }

    public HttpClient(HttpClientDefaults defaults) {
        this(new ApacheHttpClient4Factory(defaults, null));
    }

    public HttpClient(HttpClientDefaults defaults, Set<? extends HttpClientObserver> observers) {
        this(new ApacheHttpClient4Factory(defaults, observers));
    }

    public HttpClient(HttpClientFactory httpClientFactory) {
        this(httpClientFactory, new HttpClientDefaults());
    }

    public HttpClient(@Nonnull HttpClientFactory httpClientFactory, @Nonnull HttpClientDefaults httpClientDefaults) {
        Preconditions.checkArgument(httpClientFactory != null, "http client factory can not be null!");
        Preconditions.checkArgument(httpClientDefaults != null, "http client defaults can not be null!");
        this.httpClientFactory = httpClientFactory;
        this.setDefaults(httpClientDefaults);
    }

    public HttpClient start() {
        this.httpClientFactory.start();
        return this;
    }

    public HttpClient stop() {
        this.httpClientFactory.stop();
        return this;
    }

    public boolean isStarted() {
        return this.httpClientFactory.isStarted();
    }

    public boolean isStopped() {
        return this.httpClientFactory.isStopped();
    }

    @Override
    public void close() {
        this.stop();
    }

    private void setDefaults(HttpClientDefaults httpClientDefaults) {
        HttpClientConnectionContext context = this.getConnectionContext();
        if (context != null) {
            context.setConnectionTimeout(httpClientDefaults.getConnectionTimeout().getMillis());
            context.setSocketTimeout(httpClientDefaults.getSocketTimeout().getMillis());
            context.setFollowRedirects(httpClientDefaults.isFollowRedirects());
            context.setIdleTimeout(httpClientDefaults.getIdleTimeout().getMillis());
            context.setMaxRedirects(httpClientDefaults.getMaxRedirects());
            context.setPerHostConnectionsMax(httpClientDefaults.getPerHostConnectionsMax());
            context.setRequestTimeout(httpClientDefaults.getRequestTimeout().getMillis());
            context.setRetries(httpClientDefaults.getRetries());
            context.setTotalConnectionsMax(httpClientDefaults.getTotalConnectionsMax());
            context.setUserAgent(httpClientDefaults.getUserAgent());
        }
    }

    public HttpClientConnectionContext getConnectionContext() {
        return this.httpClientFactory.getConnectionContext();
    }

    public <T> HttpClientRequest.Builder<T> get(URI uri, HttpClientResponseHandler<T> httpHandler) {
        return new HttpClientRequest.Builder<T>(this.httpClientFactory, HttpClientMethod.GET, uri, httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> get(String uri, HttpClientResponseHandler<T> httpHandler) {
        return this.get(URI.create(uri), httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> head(URI uri, HttpClientResponseHandler<T> httpHandler) {
        return new HttpClientRequest.Builder<T>(this.httpClientFactory, HttpClientMethod.HEAD, uri, httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> head(String uri, HttpClientResponseHandler<T> httpHandler) {
        return this.head(URI.create(uri), httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> delete(URI uri, HttpClientResponseHandler<T> httpHandler) {
        return new HttpClientRequest.Builder<T>(this.httpClientFactory, HttpClientMethod.DELETE, uri, httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> delete(String uri, HttpClientResponseHandler<T> httpHandler) {
        return this.delete(URI.create(uri), httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> options(URI uri, HttpClientResponseHandler<T> httpHandler) {
        return new HttpClientRequest.Builder<T>(this.httpClientFactory, HttpClientMethod.OPTIONS, uri, httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> options(String uri, HttpClientResponseHandler<T> httpHandler) {
        return this.options(URI.create(uri), httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> put(URI uri, HttpClientResponseHandler<T> httpHandler) {
        return new HttpClientRequest.Builder<T>(this.httpClientFactory, HttpClientMethod.PUT, uri, httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> put(String uri, HttpClientResponseHandler<T> httpHandler) {
        return this.put(URI.create(uri), httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> post(URI uri, HttpClientResponseHandler<T> httpHandler) {
        return new HttpClientRequest.Builder<T>(this.httpClientFactory, HttpClientMethod.POST, uri, httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> post(String uri, HttpClientResponseHandler<T> httpHandler) {
        return this.post(URI.create(uri), httpHandler);
    }

    public <T> HttpClientRequest.Builder<T> perform(String methodName, URI uri, HttpClientResponseHandler<T> httpHandler) {
        HttpClientMethod method;
        try {
            method = HttpClientMethod.valueOf(methodName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown HTTP method type " + methodName, e);
        }
        return new HttpClientRequest.Builder<T>(this.httpClientFactory, method, uri, httpHandler);
    }
}

