/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient;

import com.nesscomputing.httpclient.HttpClientAuthProvider;
import java.util.Locale;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class HttpClientDefaultAuthProvider
implements HttpClientAuthProvider {
    private final String scheme;
    private final String host;
    private final int port;
    private final String realm;
    private final String user;
    private final String password;
    private transient int hashCode;
    private transient String toString;

    public static final HttpClientAuthProvider forUser(String login, String password) {
        return new HttpClientDefaultAuthProvider(null, null, -1, null, login, password);
    }

    public static final HttpClientAuthProvider forUserAndHost(String host, int port, String login, String password) {
        return new HttpClientDefaultAuthProvider(null, host, port, null, login, password);
    }

    public HttpClientDefaultAuthProvider(String scheme, String host, int port, String realm, String login, String password) {
        this.host = host != null ? host.toLowerCase(Locale.ENGLISH) : null;
        this.realm = realm != null ? realm.toLowerCase(Locale.ENGLISH) : null;
        this.scheme = scheme;
        this.port = port;
        this.user = login;
        this.password = password;
    }

    @Override
    public boolean acceptRequest(String authScheme, String authHost, int authPort, String authRealm) {
        return !(this.scheme != null && !this.scheme.equals(authScheme) || this.host != null && !this.host.equals(authHost) || this.port != -1 && this.port != authPort || this.realm != null && !this.realm.equals(authRealm));
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HttpClientDefaultAuthProvider)) {
            return false;
        }
        HttpClientDefaultAuthProvider castOther = (HttpClientDefaultAuthProvider)other;
        return new EqualsBuilder().append(this.scheme, castOther.scheme).append(this.host, castOther.host).append(this.port, castOther.port).append(this.realm, castOther.realm).append(this.user, castOther.user).append(this.password, castOther.password).isEquals();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = new HashCodeBuilder().append(this.scheme).append(this.host).append(this.port).append(this.realm).append(this.user).append(this.password).toHashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = new ToStringBuilder(this).append("scheme", this.scheme).append("host", this.host).append("port", this.port).append("realm", this.realm).append("user", this.user).append("password", this.password).toString();
        }
        return this.toString;
    }
}

