/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient;

import java.util.concurrent.TimeUnit;
import org.skife.config.Config;
import org.skife.config.Default;
import org.skife.config.DefaultNull;
import org.skife.config.TimeSpan;

public class HttpClientDefaults {
    @Config(value={"ness.httpclient.${httpclient_name}.total-connections-max", "ness.httpclient.total-connections-max"})
    @Default(value="200")
    public int getTotalConnectionsMax() {
        return 200;
    }

    @Config(value={"ness.httpclient.${httpclient_name}.perhost-connections-max", "ness.httpclient.perhost-connections-max"})
    @Default(value="20")
    public int getPerHostConnectionsMax() {
        return 20;
    }

    @Config(value={"ness.httpclient.${httpclient_name}.connection-timeout", "ness.httpclient.connection-timeout"})
    @Default(value="60s")
    public TimeSpan getConnectionTimeout() {
        return new TimeSpan(60L, TimeUnit.SECONDS);
    }

    @Config(value={"ness.httpclient.${httpclient_name}.socket-timeout", "ness.httpclient.socket-timeout"})
    @Default(value="60s")
    public TimeSpan getSocketTimeout() {
        return new TimeSpan(60L, TimeUnit.SECONDS);
    }

    @Config(value={"ness.httpclient.${httpclient_name}.idle-timeout", "ness.httpclient.idle-timeout"})
    @Default(value="15s")
    public TimeSpan getIdleTimeout() {
        return new TimeSpan(15L, TimeUnit.SECONDS);
    }

    @Config(value={"ness.httpclient.${httpclient_name}.request-timeout", "ness.httpclient.request-timeout"})
    @Default(value="60s")
    public TimeSpan getRequestTimeout() {
        return new TimeSpan(60L, TimeUnit.SECONDS);
    }

    @Config(value={"ness.httpclient.${httpclient_name}.follow-redirects", "ness.httpclient.follow-redirects"})
    @Default(value="true")
    public boolean isFollowRedirects() {
        return true;
    }

    @Config(value={"ness.httpclient.${httpclient_name}.max-redirects", "ness.httpclient.max-redirects"})
    @Default(value="5")
    public int getMaxRedirects() {
        return 5;
    }

    @Config(value={"ness.httpclient.${httpclient_name}.user-agent", "ness.httpclient.user-agent"})
    @Default(value="Ness HTTP Client")
    public String getUserAgent() {
        return "Ness HTTP Client";
    }

    @Config(value={"ness.httpclient.${httpclient_name}.retries", "ness.httpclient.retries"})
    @Default(value="3")
    public int getRetries() {
        return 3;
    }

    @Config(value={"ness.httpclient.${httpclient_name}.ssl.truststore", "ness.httpclient.ssl.truststore"})
    @Default(value="classpath:/default-truststore.jks")
    public String getSSLTruststore() {
        return "classpath:/default-truststore.jks";
    }

    @Config(value={"ness.httpclient.${httpclient_name}.ssl.truststore.password", "ness.httpclient.ssl.truststore.password"})
    @Default(value="changeit")
    public String getSSLTruststorePassword() {
        return "changeit";
    }

    @Config(value={"ness.httpclient.${httpclient_name}.ssl.truststore.fallback", "ness.httpclient.ssl.truststore.fallback"})
    @Default(value="true")
    public boolean useSSLTruststoreFallback() {
        return true;
    }

    @Config(value={"ness.httpclient.${httpclient_name}.ssl.truststore.type", "ness.httpclient.ssl.truststore.type"})
    @Default(value="JKS")
    public String getSSLTruststoreType() {
        return "JKS";
    }

    @Config(value={"ness.httpclient.${httpclient_name}.ssl.server-cert-verification", "ness.httpclient.ssl.server-cert-verification"})
    @Default(value="true")
    public boolean useSSLServerCertVerification() {
        return true;
    }

    @Config(value={"ness.httpclient.${httpclient_name}.ssl.keystore", "ness.httpclient.ssl.keystore"})
    @DefaultNull
    public String getSSLKeystore() {
        return null;
    }

    @Config(value={"ness.httpclient.${httpclient_name}.ssl.keystore.password", "ness.httpclient.ssl.keystore.password"})
    @DefaultNull
    public String getSSLKeystorePassword() {
        return null;
    }

    @Config(value={"ness.httpclient.${httpclient_name}.ssl.keystore.type", "ness.httpclient.ssl.keystore.type"})
    @Default(value="JKS")
    public String getSSLKeystoreType() {
        return "JKS";
    }
}

