/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.nesscomputing.httpclient.HttpClientAuthProvider;
import com.nesscomputing.httpclient.HttpClientDefaultAuthProvider;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.internal.HttpClientBodySource;
import com.nesscomputing.httpclient.internal.HttpClientFactory;
import com.nesscomputing.httpclient.internal.HttpClientHeader;
import com.nesscomputing.httpclient.internal.HttpClientMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;

public class HttpClientRequest<T> {
    private final HttpClientFactory httpClientFactory;
    private final HttpClientMethod httpMethod;
    private final URI url;
    private final HttpClientResponseHandler<T> httpHandler;
    private List<HttpClientHeader> headers = Collections.emptyList();
    private List<Cookie> cookies = Collections.emptyList();
    private Map<String, Object> parameters = Collections.emptyMap();
    private String virtualHost = null;
    private int virtualPort = -1;
    private HttpClientBodySource httpBodySource = null;
    private Object content = null;
    private String contentType = null;
    private String contentEncoding = null;
    private Boolean followRedirects = null;
    private List<HttpClientAuthProvider> authProviders = null;

    private HttpClientRequest(HttpClientFactory httpClientFactory, HttpClientMethod httpMethod, URI url, HttpClientResponseHandler<T> httpHandler, @Nonnull List<HttpClientHeader> headers, @Nonnull List<Cookie> cookies, @Nonnull Map<String, Object> parameters, String virtualHost, int virtualPort, @Nonnull List<HttpClientAuthProvider> authProviders, Object content, String contentType, String contentEncoding, Boolean followRedirects) {
        Preconditions.checkArgument(headers != null, "headers must not be null!");
        Preconditions.checkArgument(cookies != null, "cookies must not be null!");
        Preconditions.checkArgument(parameters != null, "parameters must not be null!");
        Preconditions.checkArgument(authProviders != null, "authProviders must not be null!");
        this.httpClientFactory = httpClientFactory;
        this.httpMethod = httpMethod;
        this.url = url;
        this.httpHandler = httpHandler;
        this.headers = Collections.unmodifiableList(headers);
        this.cookies = Collections.unmodifiableList(cookies);
        this.parameters = Collections.unmodifiableMap(parameters);
        this.virtualHost = virtualHost;
        this.virtualPort = virtualPort;
        this.authProviders = Collections.unmodifiableList(authProviders);
        this.content = content;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.followRedirects = followRedirects;
        if (content != null) {
            this.httpBodySource = httpClientFactory.getHttpBodySourceFor(content);
        }
        if (this.httpBodySource != null) {
            if (contentType != null) {
                this.httpBodySource.setContentType(contentType);
            }
            if (contentEncoding != null) {
                this.httpBodySource.setContentEncoding(contentEncoding);
            }
        }
    }

    public InputStream getContent() throws IOException {
        return this.httpBodySource.getContent();
    }

    public String getContentType() {
        return this.contentType;
    }

    public HttpClientMethod getHttpMethod() {
        return this.httpMethod;
    }

    public URI getUri() {
        return this.url;
    }

    public HttpClientResponseHandler<T> getHttpHandler() {
        return this.httpHandler;
    }

    public List<HttpClientHeader> getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public int getVirtualPort() {
        return this.virtualPort;
    }

    public List<HttpClientAuthProvider> getAuthProviders() {
        return this.authProviders;
    }

    public HttpClientBodySource getHttpBodySource() {
        return this.httpBodySource;
    }

    public Boolean followRedirects() {
        return this.followRedirects;
    }

    public T perform() throws IOException {
        return this.httpClientFactory.performRequest(this);
    }

    private Object getContentObject() {
        return this.content;
    }

    private String getContentEncoding() {
        return this.contentEncoding;
    }

    private HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }

    public String toString() {
        return String.format("HttpClientRequest [%s %s]", new Object[]{this.httpMethod, this.url});
    }

    public static final class Builder<Type> {
        private final List<HttpClientHeader> headers = Lists.newArrayList();
        private final List<Cookie> cookies = Lists.newArrayList();
        private final Map<String, Object> parameters = Maps.newHashMap();
        private final HttpClientFactory httpClientFactory;
        private final HttpClientResponseHandler<Type> httpHandler;
        private URI url;
        private final HttpClientMethod httpMethod;
        private String virtualHost;
        private int virtualPort;
        private Object content;
        private String contentType;
        private String contentEncoding;
        private Boolean followRedirects;
        private final List<HttpClientAuthProvider> authProviders = Lists.newArrayList();

        public static <T> Builder<T> fromRequest(HttpClientRequest<T> request) {
            return new Builder<T>(request);
        }

        <T> Builder(HttpClientFactory httpClientFactory, HttpClientMethod httpMethod, URI url, HttpClientResponseHandler<Type> httpHandler) {
            this.httpClientFactory = httpClientFactory;
            this.httpMethod = httpMethod;
            this.url = url;
            this.httpHandler = httpHandler;
        }

        <T> Builder(HttpClientRequest<Type> request) {
            this(((HttpClientRequest)request).getHttpClientFactory(), request.getHttpMethod(), request.getUri(), request.getHttpHandler());
            this.headers.addAll(request.getHeaders());
            this.cookies.addAll(request.getCookies());
            this.parameters.putAll(request.getParameters());
            this.authProviders.addAll(request.getAuthProviders());
            this.virtualHost = request.getVirtualHost();
            this.virtualPort = request.getVirtualPort();
            this.content = ((HttpClientRequest)request).getContentObject();
            this.contentType = request.getContentType();
            this.contentEncoding = ((HttpClientRequest)request).getContentEncoding();
            this.followRedirects = request.followRedirects();
        }

        public Builder<Type> setUrl(URI url) {
            Preconditions.checkArgument(url != null, "URI must not be null!");
            this.url = url;
            return this;
        }

        public Builder<Type> addHeader(String header, String value2) {
            Preconditions.checkArgument(header != null, "Header name must not be null!");
            Preconditions.checkArgument(value2 != null, "Header value must not be null!");
            this.headers.add(new HttpClientHeader(header, value2));
            return this;
        }

        public Builder<Type> replaceHeader(String header, String value2) {
            Iterator<HttpClientHeader> it = this.headers.iterator();
            while (it.hasNext()) {
                HttpClientHeader oldHeader = it.next();
                if (!StringUtils.equals(header, oldHeader.getName())) continue;
                it.remove();
            }
            return this.addHeader(header, value2);
        }

        public Builder<Type> addCookie(@Nonnull Cookie cookie) {
            Preconditions.checkArgument(cookie != null, "Cookie must not be null!");
            this.cookies.add(cookie);
            return this;
        }

        public Builder<Type> replaceCookie(@Nonnull Cookie cookie) {
            Iterator<Cookie> it = this.cookies.iterator();
            while (it.hasNext()) {
                Cookie oldCookie = it.next();
                if (!StringUtils.equals(cookie.getName(), oldCookie.getName())) continue;
                it.remove();
            }
            return this.addCookie(cookie);
        }

        public Builder<Type> setParameter(String key, Object value2) {
            Preconditions.checkArgument(key != null, "key must not be null!");
            this.parameters.put(key, value2);
            return this;
        }

        public Builder<Type> setVirtualHost(String virtualHost, int virtualPort) {
            this.virtualHost = virtualHost;
            this.virtualPort = virtualPort;
            return this;
        }

        public Builder<Type> setContentType(@Nonnull String contentType) {
            if (contentType == null) {
                throw new IllegalArgumentException("Content type can not be null!");
            }
            this.contentType = contentType;
            return this;
        }

        public Builder<Type> setContentEncoding(@Nonnull String contentEncoding) {
            if (contentEncoding == null) {
                throw new IllegalArgumentException("Content encoding can not be null!");
            }
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder<Type> setContent(Multimap<String, String> kvPairs, String encoding) throws UnsupportedEncodingException {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> entry : kvPairs.entries()) {
                String key = entry.getKey();
                String value2 = entry.getValue();
                if (!first) {
                    sb.append("&");
                } else {
                    first = false;
                }
                sb.append(URLEncoder.encode(key, encoding));
                sb.append("=");
                if (key == null) continue;
                sb.append(URLEncoder.encode(value2, encoding));
            }
            this.setContentEncoding(encoding);
            this.setContent(sb.toString());
            return this;
        }

        public Builder<Type> setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder<Type> setContent(byte[] content) {
            this.content = content;
            return this;
        }

        public Builder<Type> setContent(InputStream content) {
            this.content = content;
            return this;
        }

        public Builder<Type> addBasicAuth(String user, String password) {
            return this.addAuth(HttpClientDefaultAuthProvider.forUser(user, password));
        }

        public Builder<Type> addAuth(HttpClientAuthProvider authProvider) {
            this.authProviders.add(authProvider);
            return this;
        }

        public Builder<Type> followRedirects(Boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public HttpClientRequest<Type> request() {
            HttpClientRequest httpClientRequest = new HttpClientRequest(this.httpClientFactory, this.httpMethod, this.url, this.httpHandler, this.headers, this.cookies, this.parameters, this.virtualHost, this.virtualPort, this.authProviders, this.content, this.contentType, this.contentEncoding, this.followRedirects);
            return httpClientRequest;
        }

        public Type perform() throws IOException {
            return this.request().perform();
        }
    }
}

