/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.factory.httpclient4;

import com.google.common.base.Preconditions;
import com.nesscomputing.httpclient.HttpClientAuthProvider;
import com.nesscomputing.httpclient.HttpClientConnectionContext;
import com.nesscomputing.httpclient.HttpClientDefaults;
import com.nesscomputing.httpclient.HttpClientObserver;
import com.nesscomputing.httpclient.HttpClientRequest;
import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.factory.httpclient4.BetterStringEntity;
import com.nesscomputing.httpclient.factory.httpclient4.InternalCredentialsProvider;
import com.nesscomputing.httpclient.factory.httpclient4.InternalHttpBodySource;
import com.nesscomputing.httpclient.factory.httpclient4.InternalResponse;
import com.nesscomputing.httpclient.factory.httpclient4.NessCookieSpecFactory;
import com.nesscomputing.httpclient.internal.AlwaysTrustServerTrustManager;
import com.nesscomputing.httpclient.internal.HttpClientBodySource;
import com.nesscomputing.httpclient.internal.HttpClientFactory;
import com.nesscomputing.httpclient.internal.HttpClientHeader;
import com.nesscomputing.httpclient.internal.HttpClientTrustManagerFactory;
import com.nesscomputing.httpclient.internal.MultiTrustManager;
import com.nesscomputing.logging.Log;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.Cookie;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClient4Factory
implements HttpClientFactory {
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static final Scheme HTTP_SCHEME = new Scheme("http", 80, PlainSocketFactory.getSocketFactory());
    private static final Log LOG = Log.findLog();
    private final SchemeRegistry registry = new SchemeRegistry();
    private final ThreadSafeClientConnManager connectionManager;
    private final InternalConnectionContext connectionContext = new InternalConnectionContext();
    private boolean started = false;
    private boolean stopped = false;
    private final HttpParams params = new BasicHttpParams();
    private volatile int retries = 3;
    private volatile long idleTimeout = 0L;
    private volatile IdleTimeoutThread idleTimeoutThread = null;
    private final Set<? extends HttpClientObserver> httpClientObservers;

    public ApacheHttpClient4Factory(HttpClientDefaults clientDefaults, @Nullable Set<? extends HttpClientObserver> httpClientObservers) {
        Preconditions.checkArgument(clientDefaults != null, "clientDefaults can not be null!");
        this.httpClientObservers = httpClientObservers;
        this.initParams();
        this.registry.register(HTTP_SCHEME);
        try {
            TrustManager[] trustManagers = new TrustManager[]{ApacheHttpClient4Factory.getTrustManager(clientDefaults)};
            KeyManager[] keyManagers = ApacheHttpClient4Factory.getKeyManagers(clientDefaults);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext);
            this.registry.register(new Scheme("https", 443, sslSocketFactory));
        }
        catch (GeneralSecurityException ce) {
            throw new IllegalStateException(ce);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        this.connectionManager = new ThreadSafeClientConnManager(this.registry);
    }

    @Nonnull
    private static TrustManager getTrustManager(HttpClientDefaults clientDefaults) throws GeneralSecurityException, IOException {
        X509TrustManager trustManager;
        if (clientDefaults.getSSLTruststore() == null || clientDefaults.getSSLTruststorePassword() == null) {
            LOG.trace("Not using custom truststore");
            trustManager = HttpClientTrustManagerFactory.getDefaultTrustManager();
        } else {
            LOG.trace("Using custom truststore at %s", clientDefaults.getSSLTruststore());
            MultiTrustManager multiTrustManager = new MultiTrustManager();
            if (clientDefaults.useSSLTruststoreFallback()) {
                LOG.trace("Adding fallback to default trust manager");
                multiTrustManager.addTrustManager(HttpClientTrustManagerFactory.getDefaultTrustManager());
            }
            multiTrustManager.addTrustManager(HttpClientTrustManagerFactory.getTrustManagerForHttpClientDefaults(clientDefaults));
            trustManager = multiTrustManager;
        }
        if (!clientDefaults.useSSLServerCertVerification()) {
            LOG.trace("Server cert checking disabled");
            trustManager = new AlwaysTrustServerTrustManager(trustManager);
        }
        return trustManager;
    }

    @CheckForNull
    private static KeyManager[] getKeyManagers(HttpClientDefaults clientDefaults) throws IOException, GeneralSecurityException {
        if (clientDefaults.getSSLKeystore() == null || clientDefaults.getSSLKeystoreType() == null || clientDefaults.getSSLKeystorePassword() == null) {
            return null;
        }
        X509KeyManager manager = HttpClientTrustManagerFactory.getKeyManager(clientDefaults.getSSLKeystore(), clientDefaults.getSSLKeystoreType(), clientDefaults.getSSLKeystorePassword());
        return new KeyManager[]{manager};
    }

    protected Set<? extends HttpClientObserver> getHttpClientObservers() {
        return this.httpClientObservers;
    }

    @Override
    public void start() {
        if (!this.started && !this.stopped) {
            if (this.idleTimeout > 0L) {
                this.startIdleTimeoutThread();
            }
            this.started = true;
            LOG.debug("Apache HTTPClient4 based factory running.");
        }
    }

    @Override
    public void stop() {
        if (this.started && !this.stopped) {
            this.stopped = true;
            this.stopIdleTimeoutThread();
            this.connectionManager.shutdown();
            LOG.debug("Factory stopped.");
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public HttpClientConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public HttpClientBodySource getHttpBodySourceFor(Object content) {
        this.checkRunning();
        if (content == null) {
            LOG.debug("No content given, returning null");
            return null;
        }
        if (content instanceof String) {
            LOG.debug("Returning String based body source.");
            return new InternalHttpBodySource(new BetterStringEntity((String)String.class.cast(content), Charsets.UTF_8));
        }
        if (content instanceof byte[]) {
            LOG.debug("Returning byte array based body source.");
            return new InternalHttpBodySource(new ByteArrayEntity((byte[])content));
        }
        if (content instanceof InputStream) {
            LOG.debug("Returning InputStream based body source.");
            return new InternalHttpBodySource(new InputStreamEntity((InputStream)content, -1L));
        }
        return null;
    }

    @Override
    public <T> T performRequest(HttpClientRequest<T> incomingRequest) throws IOException {
        this.checkRunning();
        HttpClientRequest<T> request = incomingRequest;
        if (CollectionUtils.isNotEmpty(this.httpClientObservers)) {
            LOG.trace("Executing Observers");
            for (HttpClientObserver httpClientObserver : this.httpClientObservers) {
                request = httpClientObserver.onRequestSubmitted(request);
            }
            if (request != incomingRequest) {
                LOG.trace("Request was modified by Observers!");
            }
        }
        LOG.trace("Got a '%s' request", new Object[]{request.getHttpMethod()});
        switch (request.getHttpMethod()) {
            case DELETE: {
                return this.executeRequest(new HttpDelete(request.getUri()), request);
            }
            case HEAD: {
                return this.executeRequest(new HttpHead(request.getUri()), request);
            }
            case OPTIONS: {
                return this.executeRequest(new HttpOptions(request.getUri()), request);
            }
            case POST: {
                HttpPost httpPost = new HttpPost(request.getUri());
                HttpClientBodySource httpClientBodySource = request.getHttpBodySource();
                if (httpClientBodySource instanceof InternalHttpBodySource) {
                    httpPost.setEntity(((InternalHttpBodySource)httpClientBodySource).getHttpEntity());
                }
                return this.executeRequest(httpPost, request);
            }
            case PUT: {
                HttpPut httpPut = new HttpPut(request.getUri());
                HttpClientBodySource putSource = request.getHttpBodySource();
                if (putSource instanceof InternalHttpBodySource) {
                    httpPut.setEntity(((InternalHttpBodySource)putSource).getHttpEntity());
                }
                return this.executeRequest(httpPut, request);
            }
            case GET: {
                return this.executeRequest(new HttpGet(request.getUri()), request);
            }
        }
        LOG.warn("Got an unknown request type: '%s', falling back to GET", new Object[]{request.getHttpMethod()});
        return this.executeRequest(new HttpGet(request.getUri()), request);
    }

    private void initParams() {
        this.params.setBooleanParameter("http.protocol.single-cookie-header", true);
        this.params.setParameter("http.protocol.cookie-policy", "compatibility");
        this.params.setBooleanParameter("http.protocol.handle-redirects", true);
    }

    private void checkRunning() {
        if (!this.started || this.stopped) {
            throw new IllegalStateException("Factory was not started!");
        }
    }

    private void stopIdleTimeoutThread() {
        if (this.idleTimeoutThread != null) {
            LOG.debug("Stopping Idle Timeout Thead");
            this.idleTimeoutThread.shutdown();
            this.idleTimeoutThread = null;
        }
    }

    private void startIdleTimeoutThread() {
        this.stopIdleTimeoutThread();
        this.idleTimeoutThread = new IdleTimeoutThread();
        this.idleTimeoutThread.start();
        LOG.debug("Started Idle Timeout Thread with '%d' idle timeout", this.idleTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeRequest(HttpRequestBase httpRequest, HttpClientRequest<T> httpClientRequest) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient(this.connectionManager, this.setFollowRedirects(this.params, httpClientRequest));
        httpClient.getCookieSpecs().register("ness", new NessCookieSpecFactory());
        httpClient.setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(this.retries, false));
        this.contributeCookies(httpClient, httpClientRequest);
        this.contributeParameters(httpClient, httpRequest, httpClientRequest);
        this.contributeHeaders(httpRequest, httpClientRequest);
        this.contributeVirtualHost(httpRequest, httpClientRequest);
        this.contributeAuthentication(httpClient, httpClientRequest);
        try {
            BasicHttpContext httpContext = new BasicHttpContext();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest, httpContext);
            HttpClientResponseHandler<T> responseHandler = httpClientRequest.getHttpHandler();
            try {
                T t;
                InternalResponse internalResponse;
                HttpClientResponse response = internalResponse = new InternalResponse(httpRequest, httpResponse);
                if (CollectionUtils.isNotEmpty(this.httpClientObservers)) {
                    LOG.trace("Executing Observers");
                    for (HttpClientObserver httpClientObserver : this.httpClientObservers) {
                        response = httpClientObserver.onResponseReceived(response);
                    }
                    if (response != internalResponse) {
                        LOG.trace("Response was modified by Observers!");
                    }
                }
                if (responseHandler != null) {
                    LOG.trace("Executing Response Handler");
                    t = responseHandler.handle(response);
                    return t;
                }
                LOG.debug("No response handler found, discarding response.");
                t = null;
                return t;
            }
            finally {
                EntityUtils.consume(httpResponse.getEntity());
            }
        }
        catch (IOException ioe) {
            LOG.debug(ioe, "Aborting Request!");
            httpRequest.abort();
            throw ioe;
        }
        catch (RuntimeException re) {
            LOG.debug(re, "Aborting Request!");
            httpRequest.abort();
            throw re;
        }
    }

    private <T> void contributeCookies(DefaultHttpClient httpClient, HttpClientRequest<T> httpClientRequest) {
        List<Cookie> cookies = httpClientRequest.getCookies();
        if (CollectionUtils.isNotEmpty(cookies)) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            for (Cookie cookie : cookies) {
                BasicClientCookie httpCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
                int maxAge = cookie.getMaxAge();
                if (maxAge > 0) {
                    Date expire = new Date(System.currentTimeMillis() + (long)maxAge * 1000L);
                    httpCookie.setExpiryDate(expire);
                    httpCookie.setAttribute("max-age", Integer.toString(maxAge));
                }
                httpCookie.setVersion(1);
                httpCookie.setPath(cookie.getPath());
                httpCookie.setDomain(cookie.getDomain());
                httpCookie.setSecure(cookie.getSecure());
                LOG.debug("Adding cookie to the request: '%s'", httpCookie);
                cookieStore.addCookie(httpCookie);
            }
            httpClient.setCookieStore(cookieStore);
        } else {
            LOG.debug("No cookies found.");
            httpClient.setCookieStore(null);
        }
    }

    private <T> void contributeParameters(DefaultHttpClient httpClient, HttpRequestBase httpRequest, HttpClientRequest<T> httpClientRequest) {
        Map<String, Object> parameters = httpClientRequest.getParameters();
        if (parameters != null && parameters.size() > 0) {
            HttpParams clientParams = httpClient.getParams();
            HttpParams requestParams = httpRequest.getParams();
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                clientParams.setParameter(entry.getKey(), entry.getValue());
                requestParams.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    private <T> void contributeHeaders(HttpRequestBase httpRequest, HttpClientRequest<T> httpClientRequest) {
        String virtualHost = httpClientRequest.getVirtualHost();
        List<HttpClientHeader> headers = httpClientRequest.getHeaders();
        if (CollectionUtils.isNotEmpty(headers)) {
            for (HttpClientHeader httpHeader : headers) {
                String headerName = httpHeader.getName();
                if (virtualHost != null && "host".equals(headerName.toLowerCase(Locale.ENGLISH))) continue;
                LOG.debug("Adding Header '%s' : '%s' to the request", headerName, httpHeader.getValue());
                httpRequest.addHeader(headerName, httpHeader.getValue());
            }
        }
    }

    private <T> void contributeVirtualHost(HttpRequestBase httpRequest, HttpClientRequest<T> httpClientRequest) {
        String virtualHost = httpClientRequest.getVirtualHost();
        if (StringUtils.isNotBlank(virtualHost)) {
            LOG.debug("Adding Virtual Host: '%s/%d'", virtualHost, httpClientRequest.getVirtualPort());
            httpRequest.getParams().setParameter("http.virtual-host", new HttpHost(virtualHost, httpClientRequest.getVirtualPort()));
        }
    }

    private <T> void contributeAuthentication(DefaultHttpClient httpClient, HttpClientRequest<T> httpClientRequest) {
        List<HttpClientAuthProvider> authProviders = httpClientRequest.getAuthProviders();
        if (CollectionUtils.isNotEmpty(authProviders)) {
            httpClient.setCredentialsProvider(new InternalCredentialsProvider(authProviders));
        }
    }

    private <T> HttpParams setFollowRedirects(HttpParams params, HttpClientRequest<T> httpClientRequest) {
        Boolean followRedirects = httpClientRequest.followRedirects();
        if (followRedirects != null) {
            return params.copy().setBooleanParameter("http.protocol.handle-redirects", followRedirects);
        }
        return params;
    }

    private class IdleTimeoutThread
    extends Thread {
        private volatile boolean shutdown = false;
        private static final long magicWaitTime = 5000L;

        private IdleTimeoutThread() {
            this.setName("ApacheHttpClient4Factory IdleTimeout");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleTimeoutThread idleTimeoutThread = this;
                    synchronized (idleTimeoutThread) {
                        this.wait(5000L);
                        ApacheHttpClient4Factory.this.connectionManager.closeExpiredConnections();
                        ApacheHttpClient4Factory.this.connectionManager.closeIdleConnections(ApacheHttpClient4Factory.this.idleTimeout, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressWarnings(value={"NN_NAKED_NOTIFY"})
        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
            IdleTimeoutThread idleTimeoutThread = this;
            synchronized (idleTimeoutThread) {
                this.notifyAll();
            }
        }
    }

    private class InternalConnectionContext
    implements HttpClientConnectionContext {
        private InternalConnectionContext() {
        }

        @Override
        public void setSocketTimeout(long socketTimeout) {
            ApacheHttpClient4Factory.this.params.setIntParameter("http.socket.timeout", (int)socketTimeout);
        }

        @Override
        public void setConnectionTimeout(long connTimeout) {
            ApacheHttpClient4Factory.this.params.setIntParameter("http.connection.timeout", (int)connTimeout);
        }

        @Override
        public void setFollowRedirects(boolean followRedirects) {
            ApacheHttpClient4Factory.this.params.setBooleanParameter("http.protocol.handle-redirects", followRedirects);
        }

        @Override
        public void setIdleTimeout(long idleTimeout) {
            ApacheHttpClient4Factory.this.idleTimeout = idleTimeout;
        }

        @Override
        public void setMaxRedirects(int maxRedirects) {
            ApacheHttpClient4Factory.this.params.setIntParameter("http.protocol.max-redirects", maxRedirects);
        }

        @Override
        public void setPerHostConnectionsMax(int perHostConnectionsMax) {
            ApacheHttpClient4Factory.this.connectionManager.setDefaultMaxPerRoute(perHostConnectionsMax);
        }

        @Override
        public void setRequestTimeout(long reqTimeout) {
            ApacheHttpClient4Factory.this.params.setIntParameter("http.socket.timeout", (int)reqTimeout);
        }

        @Override
        public void setTotalConnectionsMax(int totalConnectionsMax) {
            ApacheHttpClient4Factory.this.connectionManager.setMaxTotal(totalConnectionsMax);
        }

        @Override
        public void setUserAgent(String userAgent) {
            ApacheHttpClient4Factory.this.params.setParameter("http.useragent", userAgent);
        }

        @Override
        public void setRetries(int retries) {
            ApacheHttpClient4Factory.this.retries = retries;
        }
    }
}

