/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.factory.httpclient4;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.entity.AbstractHttpEntity;

public class BetterStringEntity
extends AbstractHttpEntity
implements Cloneable {
    protected final byte[] content;

    BetterStringEntity(String string2, Charset charset) {
        Preconditions.checkArgument(string2 != null, "Source string may not be null");
        Charset charsetObj = ObjectUtils.firstNonNull(charset, Charsets.ISO_8859_1);
        this.content = string2.getBytes(charsetObj);
        this.setContentType("text/plain; charset=" + charsetObj.name());
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        outstream.write(this.content);
        outstream.flush();
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

