/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.factory.httpclient4;

import com.nesscomputing.httpclient.HttpClientAuthProvider;
import java.security.Principal;
import java.util.List;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;

public class InternalCredentialsProvider
implements CredentialsProvider {
    private final List<HttpClientAuthProvider> authProviders;

    InternalCredentialsProvider(List<HttpClientAuthProvider> authProviders) {
        this.authProviders = authProviders;
    }

    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        throw new UnsupportedOperationException("credentials can not be added to this provider!");
    }

    @Override
    public Credentials getCredentials(AuthScope authScope) {
        for (final HttpClientAuthProvider authProvider : this.authProviders) {
            if (!authProvider.acceptRequest(authScope.getScheme(), authScope.getHost(), authScope.getPort(), authScope.getRealm())) continue;
            return new Credentials(){

                @Override
                public Principal getUserPrincipal() {
                    return new BasicUserPrincipal(authProvider.getUser());
                }

                @Override
                public String getPassword() {
                    return authProvider.getPassword();
                }
            };
        }
        return null;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("credentials can not be removed from this provider!");
    }
}

