/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.factory.httpclient4;

import com.google.common.collect.Lists;
import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;

final class InternalResponse
implements HttpClientResponse {
    private static final Log LOG = Log.findLog();
    private final HttpRequestBase httpRequest;
    private final HttpResponse httpResponse;

    InternalResponse(HttpRequestBase httpRequest, HttpResponse httpResponse) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
    }

    @Override
    public String getContentType() {
        HttpEntity entity;
        if (this.httpResponse != null && (entity = this.httpResponse.getEntity()) != null) {
            Header contentType = entity.getContentType();
            return contentType == null ? null : contentType.getValue();
        }
        return null;
    }

    @Override
    public Long getContentLength() {
        Header header;
        if (this.httpResponse != null && (header = this.httpResponse.getFirstHeader("Content-Length")) != null) {
            String contentLen = StringUtils.trimToEmpty(header.getValue());
            LOG.debug("Response content length header is '%s'", contentLen);
            try {
                return Long.parseLong(contentLen);
            }
            catch (NumberFormatException nfe) {
                LOG.warnDebug(nfe, "Could not parse '%s'", contentLen);
            }
        }
        return null;
    }

    @Override
    public String getCharset() {
        HttpEntity entity;
        if (this.httpResponse != null && (entity = this.httpResponse.getEntity()) != null) {
            return EntityUtils.getContentCharSet(entity);
        }
        return null;
    }

    @Override
    public String getHeader(String name) {
        if (this.httpResponse != null) {
            Header header = this.httpResponse.getFirstHeader(name);
            return header == null ? null : header.getValue();
        }
        return null;
    }

    @Override
    @Nonnull
    public List<String> getHeaders(String name) {
        ArrayList<String> values = new ArrayList<String>();
        if (this.httpResponse != null) {
            HeaderIterator it = this.httpResponse.headerIterator(name);
            while (it.hasNext()) {
                Header header = it.nextHeader();
                values.add(header.getValue());
            }
        }
        return values;
    }

    @Override
    @Nonnull
    public Map<String, List<String>> getAllHeaders() {
        Header[] headers;
        TreeMap<String, List<String>> headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : headers = this.httpResponse.getAllHeaders()) {
            String name = header.getName();
            String value2 = header.getValue();
            LinkedList<String> valuesForThisHeader = (LinkedList<String>)headerMap.get(name);
            if (valuesForThisHeader == null) {
                valuesForThisHeader = Lists.newLinkedList();
                headerMap.put(name, valuesForThisHeader);
            }
            valuesForThisHeader.add(value2);
        }
        return headerMap;
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        HttpEntity httpEntity;
        if (this.httpResponse != null && (httpEntity = this.httpResponse.getEntity()) != null) {
            return httpEntity.getContent();
        }
        return new NullInputStream(0L);
    }

    @Override
    public int getStatusCode() {
        if (this.httpResponse != null) {
            StatusLine statusLine = this.httpResponse.getStatusLine();
            return statusLine == null ? 0 : statusLine.getStatusCode();
        }
        return 0;
    }

    @Override
    public String getStatusText() {
        if (this.httpResponse != null) {
            StatusLine statusLine = this.httpResponse.getStatusLine();
            return statusLine == null ? "" : statusLine.getReasonPhrase();
        }
        return "";
    }

    @Override
    public URI getUri() {
        return this.httpRequest == null ? null : this.httpRequest.getURI();
    }

    @Override
    public boolean isRedirected() {
        int statusCode = this.getStatusCode();
        return statusCode >= 300 && statusCode <= 399;
    }

    public String toString() {
        return String.format("InternalResponse [getContentType()=%s, getContentLength()=%s, getCharset()=%s, getAllHeaders()=%s, getStatusCode()=%s, getStatusText()=%s, getUri()=%s, isRedirected()=%s]", this.getContentType(), this.getContentLength(), this.getCharset(), this.getAllHeaders(), this.getStatusCode(), this.getStatusText(), this.getUri(), this.isRedirected());
    }
}

