/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.factory.httpclient4;

import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.params.HttpParams;

public class NessCookieSpecFactory
implements CookieSpecFactory {
    public static final String NESS_COOKIE_POLICY = "ness";

    @Override
    public CookieSpec newInstance(HttpParams params) {
        return new TrumpetCookieSpec();
    }

    public static class NessDomainHandler
    implements CookieAttributeHandler {
        @Override
        public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (value2 == null) {
                throw new MalformedCookieException("Missing value for domain attribute");
            }
            if (value2.trim().length() == 0) {
                throw new MalformedCookieException("Blank value for domain attribute");
            }
            cookie.setDomain(value2);
        }

        @Override
        public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (origin == null) {
                throw new IllegalArgumentException("Cookie origin may not be null");
            }
        }

        @Override
        public boolean match(Cookie cookie, CookieOrigin origin) {
            if (cookie == null) {
                throw new IllegalArgumentException("Cookie may not be null");
            }
            if (origin == null) {
                throw new IllegalArgumentException("Cookie origin may not be null");
            }
            return true;
        }
    }

    public static class TrumpetCookieSpec
    extends BrowserCompatSpec {
        TrumpetCookieSpec() {
            this.registerAttribHandler("domain", new NessDomainHandler());
        }

        @Override
        public String toString() {
            return NessCookieSpecFactory.NESS_COOKIE_POLICY;
        }
    }
}

