/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.nesscomputing.config.ConfigProvider;
import com.nesscomputing.httpclient.HttpClient;
import com.nesscomputing.httpclient.HttpClientDefaults;
import com.nesscomputing.httpclient.HttpClientObserver;
import com.nesscomputing.httpclient.HttpClientObserverGroup;
import com.nesscomputing.httpclient.factory.httpclient4.ApacheHttpClient4Factory;
import com.nesscomputing.httpclient.internal.HttpClientFactory;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.guice.AbstractLifecycleProvider;
import com.nesscomputing.lifecycle.guice.LifecycleAction;
import com.nesscomputing.logging.Log;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class HttpClientModule
extends AbstractModule {
    private static final Log LOG = Log.findLog();
    private static final String OBSERVER_GROUP = "__observer_groups";
    private static final String INHERIT_MAP = "__observer_group_inherit";
    private final String clientName;
    private final Set<HttpClientObserverGroup> observerGroups;

    public HttpClientModule(@Nonnull String clientName, HttpClientObserverGroup ... observerGroups) {
        Preconditions.checkArgument(clientName != null, "client name can not be null");
        this.clientName = clientName;
        this.observerGroups = ImmutableSet.copyOf(observerGroups);
    }

    @Override
    public void configure() {
        Map<String, String> optionMap = Collections.singletonMap("httpclient_name", this.clientName);
        Named annotation = Names.named(this.clientName);
        this.bind(HttpClientDefaults.class).annotatedWith(annotation).toProvider(ConfigProvider.of(null, HttpClientDefaults.class, optionMap)).in(Scopes.SINGLETON);
        this.bind(HttpClientFactory.class).annotatedWith(annotation).toProvider(new ApacheHttpClient4FactoryProvider(annotation, this.observerGroups)).in(Scopes.SINGLETON);
        this.bind(HttpClient.class).annotatedWith(annotation).toProvider(new HttpClientProvider(annotation)).asEagerSingleton();
        MapBinder.newMapBinder(this.binder(), HttpClientObserverGroup.class, HttpClientObserver.class, (Annotation)Names.named(OBSERVER_GROUP)).permitDuplicates();
        MapBinder.newMapBinder(this.binder(), HttpClientObserverGroup.class, HttpClientObserverGroup.class, (Annotation)Names.named(INHERIT_MAP)).permitDuplicates();
    }

    public static LinkedBindingBuilder<HttpClientObserver> bindNewObserver(Binder binder) {
        return Multibinder.newSetBinder(binder, HttpClientObserver.class).addBinding();
    }

    public static LinkedBindingBuilder<HttpClientObserver> bindNewObserver(Binder binder, Annotation annotation) {
        return Multibinder.newSetBinder(binder, HttpClientObserver.class, annotation).addBinding();
    }

    public static LinkedBindingBuilder<HttpClientObserver> bindNewObserver(Binder binder, HttpClientObserverGroup observerGroup) {
        return MapBinder.newMapBinder(binder, HttpClientObserverGroup.class, HttpClientObserver.class, (Annotation)Names.named(OBSERVER_GROUP)).addBinding(observerGroup);
    }

    public static void addObserverGroupInheritance(Binder binder, HttpClientObserverGroup subGroup, HttpClientObserverGroup superGroup) {
        MapBinder.newMapBinder(binder, HttpClientObserverGroup.class, HttpClientObserverGroup.class, (Annotation)Names.named(INHERIT_MAP)).addBinding(subGroup).toInstance(superGroup);
    }

    static final class ApacheHttpClient4FactoryProvider
    implements Provider<HttpClientFactory> {
        private static final TypeLiteral<Set<HttpClientObserver>> OBSERVER_TYPE_LITERAL = new TypeLiteral<Set<HttpClientObserver>>(){};
        private final Annotation annotation;
        private final Set<HttpClientObserverGroup> observerGroups;
        private Injector injector;
        private Map<HttpClientObserverGroup, Set<HttpClientObserver>> groupObserverMap;
        private Map<HttpClientObserverGroup, Set<HttpClientObserverGroup>> groupInheritanceMap;

        private ApacheHttpClient4FactoryProvider(@Nonnull Annotation annotation, Set<HttpClientObserverGroup> observerGroups) {
            this.annotation = annotation;
            this.observerGroups = observerGroups;
        }

        @Inject
        void setInjector(Injector injector, @Named(value="__observer_groups") Map<HttpClientObserverGroup, Set<HttpClientObserver>> groupObserverMap, @Named(value="__observer_group_inherit") Map<HttpClientObserverGroup, Set<HttpClientObserverGroup>> groupInheritanceMap) {
            this.injector = injector;
            this.groupObserverMap = groupObserverMap;
            this.groupInheritanceMap = groupInheritanceMap;
        }

        private Set<HttpClientObserver> findObservers(Key<Set<HttpClientObserver>> key) {
            if (this.injector.getExistingBinding(key) != null) {
                return this.injector.getInstance(key);
            }
            return Collections.emptySet();
        }

        private Set<HttpClientObserver> findObserversForGroups() {
            HashSet<HttpClientObserverGroup> seen = new HashSet<HttpClientObserverGroup>();
            HashSet<HttpClientObserver> result2 = new HashSet<HttpClientObserver>();
            for (HttpClientObserverGroup group : this.observerGroups) {
                result2.addAll(this.findObservers(group, seen));
            }
            return result2;
        }

        private Set<HttpClientObserver> findObservers(HttpClientObserverGroup group, Set<HttpClientObserverGroup> seen) {
            Set<HttpClientObserverGroup> inheritGroups;
            if (!seen.add(group)) {
                return Collections.emptySet();
            }
            HashSet<HttpClientObserver> result2 = new HashSet<HttpClientObserver>();
            Set<HttpClientObserver> observers = this.groupObserverMap.get(group);
            if (observers != null) {
                result2.addAll(observers);
            }
            if ((inheritGroups = this.groupInheritanceMap.get(group)) != null) {
                for (HttpClientObserverGroup superGroup : inheritGroups) {
                    result2.addAll(this.findObservers(superGroup, seen));
                }
            }
            return result2;
        }

        @Override
        public HttpClientFactory get() {
            ImmutableCollection httpClientObservers = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.findObservers(Key.get(OBSERVER_TYPE_LITERAL)))).addAll(this.findObservers(Key.get(OBSERVER_TYPE_LITERAL, this.annotation)))).addAll(this.findObserversForGroups())).build();
            LOG.info("HttpClient '%s' has observers: %s", httpClientObservers);
            HttpClientDefaults httpClientDefaults = this.injector.getInstance(Key.get(HttpClientDefaults.class, this.annotation));
            return new ApacheHttpClient4Factory(httpClientDefaults, (Set<? extends HttpClientObserver>)((Object)httpClientObservers));
        }
    }

    static final class HttpClientProvider
    extends AbstractLifecycleProvider<HttpClient>
    implements Provider<HttpClient> {
        private HttpClientDefaults httpClientDefaults = null;
        private HttpClientFactory httpClientFactory = null;
        private final Annotation annotation;

        private HttpClientProvider(@Nonnull Annotation annotation) {
            this.annotation = annotation;
            this.addAction(LifecycleStage.START_STAGE, new LifecycleAction<HttpClient>(){

                @Override
                public void performAction(HttpClient httpClient) {
                    httpClient.start();
                }
            });
            this.addAction(LifecycleStage.STOP_STAGE, new LifecycleAction<HttpClient>(){

                @Override
                public void performAction(HttpClient httpClient) {
                    httpClient.stop();
                }
            });
        }

        @Inject
        public void setInjector(Injector injector) {
            this.httpClientDefaults = injector.getInstance(Key.get(HttpClientDefaults.class, this.annotation));
            this.httpClientFactory = injector.getInstance(Key.get(HttpClientFactory.class, this.annotation));
        }

        @Override
        public HttpClient internalGet() {
            return new HttpClient(this.httpClientFactory, this.httpClientDefaults);
        }
    }
}

