/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.nesscomputing.httpclient.HttpClientDefaults;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;

public final class HttpClientTrustManagerFactory {
    private static final Log LOG = Log.findLog();

    private HttpClientTrustManagerFactory() {
    }

    @Nonnull
    public static X509KeyManager getKeyManager(String keystorePath, String keystoreType, String keystorePassword) throws IOException, GeneralSecurityException {
        Preconditions.checkArgument(keystorePath != null, "keystore path must not be null!");
        Preconditions.checkArgument(keystoreType != null, "keystore type must not be null!");
        Preconditions.checkArgument(keystorePassword != null, "keystore password must not be null!");
        KeyStore keyStore = HttpClientTrustManagerFactory.loadKeystore(keystorePath, keystoreType, keystorePassword);
        return HttpClientTrustManagerFactory.getKeyManagerForKeystore(keyStore, keystorePassword);
    }

    @Nonnull
    public static X509TrustManager getDefaultTrustManager() throws GeneralSecurityException {
        return HttpClientTrustManagerFactory.trustManagerFromKeystore(null);
    }

    @Nonnull
    public static X509TrustManager getTrustManagerForHttpClientDefaults(HttpClientDefaults clientDefaults) throws GeneralSecurityException, IOException {
        KeyStore keystore = HttpClientTrustManagerFactory.loadKeystore(clientDefaults.getSSLTruststore(), clientDefaults.getSSLTruststoreType(), clientDefaults.getSSLTruststorePassword());
        return HttpClientTrustManagerFactory.trustManagerFromKeystore(keystore);
    }

    @Nonnull
    private static KeyStore loadKeystore(@Nonnull String location, @Nonnull String keystoreType, @Nonnull String keystorePassword) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        URL keystoreUrl = StringUtils.startsWithIgnoreCase(location, "classpath:") ? Resources.getResource(HttpClientTrustManagerFactory.class, location.substring(10)) : new URL(location);
        keystore.load(keystoreUrl.openStream(), keystorePassword.toCharArray());
        return keystore;
    }

    @Nonnull
    private static X509KeyManager getKeyManagerForKeystore(@Nonnull KeyStore keyStore, @Nonnull String password) throws GeneralSecurityException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
        keyManagerFactory.init(keyStore, password.toCharArray());
        for (KeyManager keyManager : keyManagerFactory.getKeyManagers()) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        throw new IllegalStateException("Couldn't find an X509KeyManager");
    }

    @Nonnull
    private static X509TrustManager trustManagerFromKeystore(KeyStore keystore) throws GeneralSecurityException {
        TrustManager[] tms;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
        trustManagerFactory.init(keystore);
        for (TrustManager tm : tms = trustManagerFactory.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            X509TrustManager manager = (X509TrustManager)tm;
            X509Certificate[] acceptedIssuers = manager.getAcceptedIssuers();
            LOG.debug("Found TrustManager with %d authorities.", acceptedIssuers.length);
            for (int i = 0; i < acceptedIssuers.length; ++i) {
                X509Certificate issuer = acceptedIssuers[i];
                LOG.trace("Issuer #%d, subject DN=<%s>, serial=<%s>", i, issuer.getSubjectDN(), issuer.getSerialNumber());
            }
            return manager;
        }
        throw new IllegalStateException("Could not find an X509TrustManager");
    }
}

