/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.internal;

import com.google.common.collect.Sets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.X509TrustManager;

public class MultiTrustManager
implements X509TrustManager {
    private final Set<X509TrustManager> trustManagers = Sets.newHashSet();

    public void addTrustManager(X509TrustManager trustManager) {
        this.trustManagers.add(trustManager);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain2, String authType) throws CertificateException {
        if (this.trustManagers.isEmpty()) {
            throw new CertificateException("No trust managers installed!");
        }
        CertificateException ce = null;
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkClientTrusted(chain2, authType);
                return;
            }
            catch (CertificateException trustCe) {
                ce = trustCe;
            }
        }
        throw ce;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain2, String authType) throws CertificateException {
        if (this.trustManagers.isEmpty()) {
            throw new CertificateException("No trust managers installed!");
        }
        CertificateException ce = null;
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkServerTrusted(chain2, authType);
                return;
            }
            catch (CertificateException trustCe) {
                ce = trustCe;
            }
        }
        throw ce;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        HashSet<X509Certificate> certificates = Sets.newHashSet();
        for (X509TrustManager trustManager : this.trustManagers) {
            certificates.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
        }
        return certificates.toArray(new X509Certificate[certificates.size()]);
    }
}

