/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.io;

import com.nesscomputing.httpclient.io.SizeExceededException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SizeLimitingInputStream
extends FilterInputStream {
    private final int maxSize;
    private int count;
    private int mark = -1;

    public SizeLimitingInputStream(InputStream in, int limit) throws IOException {
        super(in);
        this.maxSize = limit;
        if (in.available() > limit) {
            this.throwException();
        }
    }

    private final void ensureLimit() throws SizeExceededException {
        if (this.count > this.maxSize) {
            this.throwException();
        }
    }

    private final void throwException() throws SizeExceededException {
        throw new SizeExceededException("SizeLimitInputStream: maximum size %d exceeded, actual = %d", this.maxSize, this.count);
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r > 0) {
            this.count += r;
        }
        this.ensureLimit();
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r > 0) {
            this.count += r;
        }
        this.ensureLimit();
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.in.skip(n);
        if (r > 0L) {
            this.count += (int)r;
        }
        this.ensureLimit();
        return r;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.count;
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark > 0) {
            this.count = this.mark;
        }
        this.mark = -1;
        this.in.reset();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

