/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.response;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.response.ContentConverter;
import com.nesscomputing.httpclient.response.HttpResponseException;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public abstract class AbstractErrorHandlingContentConverter<T>
implements ContentConverter<T> {
    private static final int MAX_RESPONSE_PRINT_CHARS = 4096;
    private static final Log LOG = Log.findLog();

    @Override
    public T handleError(HttpClientResponse httpClientResponse, IOException ex) throws IOException {
        if (httpClientResponse != null) {
            LOG.trace("Failure cause is: %s", httpClientResponse.getStatusText());
        }
        throw ex;
    }

    public static HttpResponseException throwHttpResponseException(HttpClientResponse response) throws IOException {
        LOG.warn("Remote service responded to \"%s\" with code %d (cause: %s) %s", response.getUri(), response.getStatusCode(), response.getStatusText(), AbstractErrorHandlingContentConverter.printData(response));
        throw new HttpResponseException(response);
    }

    private static String printData(HttpClientResponse response) throws IOException {
        try {
            Charset charset;
            if (!LOG.isInfoEnabled()) {
                return "(response body available, turn on INFO log to see it)";
            }
            String charsetName = Objects.firstNonNull(response.getCharset(), Charsets.UTF_8.name());
            try {
                charset = Charset.forName(charsetName);
            }
            catch (IllegalArgumentException e) {
                LOG.warn(e, "While finding charset '%s'", charsetName);
                return String.format("(invalid charset %s: %s)", charsetName, e);
            }
            InputStreamReader in = new InputStreamReader(response.getResponseBodyAsStream(), charset);
            char[] buffer = new char[4096];
            buffer[0] = 10;
            int len = IOUtils.read(in, buffer, 1, buffer.length - 1);
            return new String(buffer, 0, len + 1);
        }
        catch (Exception e) {
            LOG.error(e, "While reading characters from errored response");
            return String.format("(exception: %s)", e);
        }
    }
}

