/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.response;

import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.io.SizeExceededException;
import com.nesscomputing.httpclient.io.SizeLimitingInputStream;
import com.nesscomputing.httpclient.response.ContentConverter;
import com.nesscomputing.httpclient.response.HttpResponseException;
import com.nesscomputing.httpclient.response.RedirectedException;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;

public class ContentResponseHandler<T>
implements HttpClientResponseHandler<T> {
    private static final Log LOG = Log.findLog();
    private final ContentConverter<T> contentConverter;
    private final int maxBodyLength;
    private final boolean allowRedirect;

    public static <CC> ContentResponseHandler<CC> forConverter(ContentConverter<CC> contentConverter) {
        return new ContentResponseHandler<CC>(contentConverter);
    }

    public ContentResponseHandler(ContentConverter<T> contentConverter) {
        this(contentConverter, -1, false);
    }

    public ContentResponseHandler(ContentConverter<T> contentConverter, int maxBodyLength) {
        this(contentConverter, maxBodyLength, false);
    }

    public ContentResponseHandler(ContentConverter<T> contentConverter, int maxBodyLength, boolean allowRedirect) {
        this.contentConverter = contentConverter;
        this.maxBodyLength = maxBodyLength;
        this.allowRedirect = allowRedirect;
    }

    @Override
    public T handle(HttpClientResponse response) throws IOException {
        if (this.allowRedirect && response.isRedirected()) {
            LOG.debug("Redirecting based on '%d' response code", response.getStatusCode());
            throw new RedirectedException(response);
        }
        InputStream is = null;
        try {
            is = response.getResponseBodyAsStream();
        }
        catch (IOException e) {
            LOG.warnDebug(e, "Could not locate response body stream");
        }
        if (is == null) {
            is = new NullInputStream(0L);
        }
        try {
            String encoding;
            Long contentLength = response.getContentLength();
            if (this.maxBodyLength > 0) {
                if (contentLength != null && contentLength > (long)this.maxBodyLength) {
                    throw new SizeExceededException("Content-Length: " + String.valueOf(contentLength), new Object[0]);
                }
                LOG.debug("Limiting stream length to '%d'", this.maxBodyLength);
                is = new SizeLimitingInputStream(is, this.maxBodyLength);
            }
            if (StringUtils.equalsIgnoreCase(encoding = StringUtils.trimToEmpty(response.getHeader("Content-Encoding")), "gzip") || StringUtils.equalsIgnoreCase(encoding, "x-gzip")) {
                LOG.debug("Found GZIP stream");
                is = new GZIPInputStream(is);
            } else if (StringUtils.equalsIgnoreCase(encoding, "deflate")) {
                LOG.debug("Found deflate stream");
                Inflater inflater = new Inflater(true);
                is = new InflaterInputStream(is, inflater);
            }
            return this.contentConverter.convert(response, is);
        }
        catch (HttpResponseException hre) {
            throw hre;
        }
        catch (IOException ioe) {
            return this.contentConverter.handleError(response, ioe);
        }
    }
}

