/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.response;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HttpResponse {
    private final byte[] body;
    @Nullable
    private final String charset;
    private final int statusCode;
    private final Multimap<String, String> headers;

    HttpResponse(int statusCode, @Nonnull byte[] body, @Nullable String charset, @Nonnull Multimap<String, String> headers) {
        this.statusCode = statusCode;
        this.body = body;
        this.charset = charset;
        this.headers = ImmutableMultimap.copyOf(headers);
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Nonnull
    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getBody() {
        return this.body;
    }

    @Nonnull
    public String getBodyAsString() throws UnsupportedEncodingException {
        if (this.charset == null) {
            return new String(this.body, Charsets.UTF_8);
        }
        return new String(this.body, this.charset);
    }
}

