/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.response;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.response.ContentConverter;
import com.nesscomputing.httpclient.response.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class HttpResponseContentConverter
implements ContentConverter<HttpResponse> {
    @Override
    public HttpResponse convert(HttpClientResponse response, InputStream inputStream) throws IOException {
        return new HttpResponse(response.getStatusCode(), IOUtils.toByteArray(inputStream), response.getCharset(), this.headersFor(response.getAllHeaders()));
    }

    private Multimap<String, String> headersFor(Map<String, List<String>> allHeaders) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry<String, List<String>> e : allHeaders.entrySet()) {
            builder.putAll(e.getKey(), (Iterable)e.getValue());
        }
        return builder.build();
    }

    @Override
    public HttpResponse handleError(HttpClientResponse response, IOException ex) throws IOException {
        throw ex;
    }
}

