/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.response;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.response.AbstractErrorHandlingContentConverter;
import com.nesscomputing.httpclient.response.ContentConverter;
import com.nesscomputing.httpclient.response.ContentResponseHandler;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.io.InputStream;

public class JsonContentConverter<T>
extends AbstractErrorHandlingContentConverter<T> {
    private static final Log LOG = Log.findLog();
    private final TypeReference<T> typeReference;
    private final ObjectMapper objectMapper;
    private final boolean ignore404;

    public static <CC> ContentResponseHandler<CC> getResponseHandler(TypeReference<CC> typeReference, ObjectMapper objectMapper) {
        return ContentResponseHandler.forConverter(JsonContentConverter.getConverter(typeReference, objectMapper));
    }

    public static <Type> ContentConverter<Type> getConverter(TypeReference<Type> typeReference, ObjectMapper objectMapper) {
        return new JsonContentConverter<Type>(typeReference, objectMapper);
    }

    public static <CC> ContentResponseHandler<CC> getResponseHandler(TypeReference<CC> typeReference, ObjectMapper objectMapper, boolean ignore404) {
        return ContentResponseHandler.forConverter(JsonContentConverter.getConverter(typeReference, objectMapper, ignore404));
    }

    public static <Type> ContentConverter<Type> getConverter(TypeReference<Type> typeReference, ObjectMapper objectMapper, boolean ignore404) {
        return new JsonContentConverter<Type>(typeReference, objectMapper, ignore404);
    }

    public JsonContentConverter(TypeReference<T> typeReference, ObjectMapper objectMapper) {
        this(typeReference, objectMapper, false);
    }

    public JsonContentConverter(TypeReference<T> typeReference, ObjectMapper objectMapper, boolean ignore404) {
        this.typeReference = typeReference;
        this.objectMapper = objectMapper;
        this.ignore404 = ignore404;
    }

    @Override
    public T convert(HttpClientResponse httpClientResponse, InputStream inputStream) throws IOException {
        int responseCode = httpClientResponse.getStatusCode();
        switch (responseCode) {
            case 200: {
                return this.objectMapper.readValue(inputStream, this.typeReference);
            }
            case 204: {
                return null;
            }
            case 201: {
                try {
                    return this.objectMapper.readValue(inputStream, this.typeReference);
                }
                catch (JsonParseException jpe) {
                    LOG.trace(jpe, "while reading response");
                    return null;
                }
            }
            case 404: {
                if (!this.ignore404) break;
                return null;
            }
        }
        throw JsonContentConverter.throwHttpResponseException(httpClientResponse);
    }
}

