/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.response;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.response.AbstractErrorHandlingContentConverter;
import com.nesscomputing.httpclient.response.ContentConverter;
import com.nesscomputing.httpclient.response.ContentResponseHandler;
import com.nesscomputing.logging.Log;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import javax.annotation.concurrent.Immutable;

@Immutable
public class NumberContentConverter<T extends Number>
extends AbstractErrorHandlingContentConverter<T> {
    private static final Log LOG = Log.findLog();
    private final boolean ignore404;
    private final Class<T> numberClass;
    private final Method valueOfMethod;
    private final T emptyValue;

    public static <N extends Number> ContentResponseHandler<N> getResponseHandler(Class<N> numberClass, boolean ignore404) {
        return ContentResponseHandler.forConverter(NumberContentConverter.getConverter(numberClass, ignore404));
    }

    public static <N extends Number> ContentConverter<N> getConverter(Class<N> numberClass, boolean ignore404) {
        return new NumberContentConverter<N>(numberClass, ignore404);
    }

    protected NumberContentConverter(Class<T> numberClass, boolean ignore404) {
        try {
            this.numberClass = numberClass;
            this.ignore404 = ignore404;
            this.valueOfMethod = numberClass.getMethod("valueOf", String.class);
            this.emptyValue = (Number)numberClass.cast(this.safeInvoke("0"));
        }
        catch (NoSuchMethodException nsme) {
            throw Throwables.propagate(nsme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T convert(HttpClientResponse httpClientResponse, InputStream inputStream) throws IOException {
        int responseCode = httpClientResponse.getStatusCode();
        switch (responseCode) {
            case 200: 
            case 201: {
                Charset charset = Charset.forName(Objects.firstNonNull(httpClientResponse.getCharset(), "UTF-8"));
                InputStreamReader reader = new InputStreamReader(inputStream, charset);
                try {
                    String data2 = CharStreams.toString(reader);
                    Number result2 = (Number)this.numberClass.cast(this.safeInvoke(data2));
                    if (result2 == null) {
                        if (responseCode == 201) {
                            T t = this.emptyValue;
                            return t;
                        }
                        throw new IllegalArgumentException(String.format("Could not parse result '%s'", data2));
                    }
                    Number number2 = result2;
                    return (T)number2;
                }
                finally {
                    Closeables.closeQuietly((Closeable)reader);
                }
            }
            case 204: {
                return this.emptyValue;
            }
            case 404: {
                if (!this.ignore404) break;
                return this.emptyValue;
            }
        }
        throw NumberContentConverter.throwHttpResponseException(httpClientResponse);
    }

    private Object safeInvoke(String value2) {
        try {
            return this.valueOfMethod.invoke(null, value2);
        }
        catch (Exception e) {
            LOG.warnDebug(e, "while reading %s", value2);
            return null;
        }
    }
}

