/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.response;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.nesscomputing.callback.Callback;
import com.nesscomputing.callback.CallbackRefusedException;
import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.response.AbstractErrorHandlingContentConverter;
import com.nesscomputing.httpclient.response.ContentResponseHandler;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class StreamedJsonContentConverter<T>
extends AbstractErrorHandlingContentConverter<Void> {
    private static final Log LOG = Log.findLog();
    private static final TypeReference<Map<String, ? extends Object>> JSON_MAP_TYPE_REF = new TypeReference<Map<String, ? extends Object>>(){};
    private final ObjectMapper mapper;
    private final TypeReference<T> typeRef;
    private final Callback<? super T> callback;

    public static StreamedJsonContentConverter<Map<String, ? extends Object>> of(ObjectMapper mapper, Callback<Map<String, ? extends Object>> callback) {
        return new StreamedJsonContentConverter<Map<String, ? extends Object>>(mapper, callback, JSON_MAP_TYPE_REF);
    }

    public static HttpClientResponseHandler<Void> handle(ObjectMapper mapper, Callback<Map<String, ? extends Object>> callback) {
        return ContentResponseHandler.forConverter(new StreamedJsonContentConverter<Map<String, ? extends Object>>(mapper, callback, JSON_MAP_TYPE_REF));
    }

    public static <T> HttpClientResponseHandler<Void> handle(ObjectMapper mapper, Callback<? super T> callback, TypeReference<T> typeReference) {
        return ContentResponseHandler.forConverter(new StreamedJsonContentConverter<T>(mapper, callback, typeReference));
    }

    StreamedJsonContentConverter(ObjectMapper mapper, Callback<? super T> callback, TypeReference<T> typeRef) {
        this.mapper = mapper;
        this.typeRef = typeRef;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void convert(HttpClientResponse response, InputStream inputStream) throws IOException {
        switch (response.getStatusCode()) {
            case 201: 
            case 204: {
                LOG.debug("Return code is %d, finishing.", response.getStatusCode());
                return null;
            }
            case 200: {
                try (JsonParser jp = this.mapper.getFactory().createJsonParser(inputStream);){
                    this.expect(jp, jp.nextToken(), JsonToken.START_OBJECT);
                    this.expect(jp, jp.nextToken(), JsonToken.FIELD_NAME);
                    if (!"results".equals(jp.getCurrentName())) {
                        throw new JsonParseException("expecting results field", jp.getCurrentLocation());
                    }
                    this.expect(jp, jp.nextToken(), JsonToken.START_ARRAY);
                    while (jp.nextToken() != JsonToken.END_ARRAY) {
                        try {
                            Object data2 = jp.readValueAs(this.typeRef);
                            this.callback.call(data2);
                        }
                        catch (CallbackRefusedException e) {
                            LOG.debug(e, "callback refused execution, finishing.");
                            Void void_ = null;
                            jp.close();
                            return void_;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Callback interrupted", e);
                        }
                        catch (Exception e) {
                            Throwables.propagateIfPossible(e, IOException.class);
                            throw new IOException("Callback failure", e);
                        }
                    }
                    if (jp.nextValue() != JsonToken.VALUE_TRUE || !jp.getCurrentName().equals("success")) {
                        throw new IOException("Streamed receive did not terminate normally; inspect server logs for cause.");
                    }
                    Void void_ = null;
                    return void_;
                }
            }
        }
        throw StreamedJsonContentConverter.throwHttpResponseException(response);
    }

    private void expect(JsonParser jp, JsonToken token2, JsonToken expected) throws JsonParseException {
        if (!Objects.equal((Object)token2, (Object)expected)) {
            throw new JsonParseException(String.format("Expected %s, found %s", new Object[]{expected, token2}), jp.getCurrentLocation());
        }
    }
}

