/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.response;

import com.google.common.base.Objects;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.response.AbstractErrorHandlingContentConverter;
import com.nesscomputing.httpclient.response.ContentConverter;
import com.nesscomputing.httpclient.response.ContentResponseHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StringContentConverter
extends AbstractErrorHandlingContentConverter<String> {
    public static final ContentConverter<String> DEFAULT_CONVERTER = new StringContentConverter();
    public static final ContentConverter<String> DEFAULT_404OK_CONVERTER = new StringContentConverter(true);
    public static final ContentResponseHandler<String> DEFAULT_RESPONSE_HANDLER = ContentResponseHandler.forConverter(DEFAULT_CONVERTER);
    public static final ContentResponseHandler<String> DEFAULT_404OK_RESPONSE_HANDLER = ContentResponseHandler.forConverter(DEFAULT_404OK_CONVERTER);
    private final boolean ignore404;

    protected StringContentConverter() {
        this(false);
    }

    protected StringContentConverter(boolean ignore404) {
        this.ignore404 = ignore404;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convert(HttpClientResponse httpClientResponse, InputStream inputStream) throws IOException {
        int responseCode = httpClientResponse.getStatusCode();
        switch (responseCode) {
            case 200: 
            case 201: {
                Charset charset = Charset.forName(Objects.firstNonNull(httpClientResponse.getCharset(), "UTF-8"));
                InputStreamReader reader = new InputStreamReader(inputStream, charset);
                try {
                    String string2 = CharStreams.toString(reader);
                    return string2;
                }
                finally {
                    Closeables.closeQuietly((Closeable)reader);
                }
            }
            case 204: {
                return "";
            }
            case 404: {
                if (!this.ignore404) break;
                return "";
            }
        }
        throw StringContentConverter.throwHttpResponseException(httpClientResponse);
    }
}

