/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpclient.response;

import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.response.AbstractErrorHandlingContentConverter;
import com.nesscomputing.httpclient.response.ContentResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Valid2xxContentConverter
extends AbstractErrorHandlingContentConverter<Boolean> {
    public static final Valid2xxContentConverter DEFAULT_CONVERTER = new Valid2xxContentConverter(false);
    public static final Valid2xxContentConverter DEFAULT_FAILING_CONVERTER = new Valid2xxContentConverter(true);
    public static final Valid2xxContentConverter DEFAULT_404OK_CONVERTER = new Valid2xxContentConverter(true, true);
    public static final ContentResponseHandler<Boolean> DEFAULT_RESPONSE_HANDLER = ContentResponseHandler.forConverter(DEFAULT_CONVERTER);
    public static final ContentResponseHandler<Boolean> DEFAULT_FAILING_RESPONSE_HANDLER = ContentResponseHandler.forConverter(DEFAULT_FAILING_CONVERTER);
    public static final ContentResponseHandler<Boolean> DEFAULT_404OK_RESPONSE_HANDLER = ContentResponseHandler.forConverter(DEFAULT_404OK_CONVERTER);
    private final boolean failOnError;
    private final boolean ignore404;

    protected Valid2xxContentConverter(boolean failOnError) {
        this(failOnError, false);
    }

    protected Valid2xxContentConverter(boolean failOnError, boolean ignore404) {
        this.failOnError = failOnError;
        this.ignore404 = ignore404;
    }

    @Override
    public Boolean convert(HttpClientResponse httpClientResponse, InputStream inputStream) throws IOException {
        int responseCode = httpClientResponse.getStatusCode();
        switch (responseCode) {
            case 200: 
            case 201: 
            case 204: {
                return Boolean.TRUE;
            }
            case 404: {
                if (!this.ignore404) break;
                return Boolean.FALSE;
            }
        }
        if (this.failOnError) {
            throw Valid2xxContentConverter.throwHttpResponseException(httpClientResponse);
        }
        return Boolean.FALSE;
    }
}

