/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.nesscomputing.jackson.JacksonFormatConfig;
import com.nesscomputing.jackson.JsonMapper;
import com.nesscomputing.jackson.SmileMapper;
import com.nesscomputing.logging.Log;

public class JacksonFormatObjectMapperProvider
implements Provider<ObjectMapper> {
    private final Log LOG = Log.findLog();
    private final JacksonFormatConfig jacksonFormatConfig;
    private ObjectMapper objectMapper = null;

    public JacksonFormatObjectMapperProvider(JacksonFormatConfig jacksonFormatConfig) {
        this.jacksonFormatConfig = jacksonFormatConfig;
    }

    @Inject(optional=true)
    void injectObjectMappers(@JsonMapper ObjectMapper jsonObjectMapper, @SmileMapper ObjectMapper smileObjectMapper) {
        switch (this.jacksonFormatConfig.getDataFormat()) {
            case JSON: {
                this.LOG.trace("Using JSON format");
                this.objectMapper = jsonObjectMapper;
                break;
            }
            case SMILE: {
                this.LOG.trace("Using SMILE format");
                this.objectMapper = smileObjectMapper;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown format " + (Object)((Object)this.jacksonFormatConfig.getDataFormat()));
            }
        }
    }

    @Override
    public ObjectMapper get() {
        Preconditions.checkState(this.objectMapper != null, "Object mapper was not set!");
        return this.objectMapper;
    }
}

