/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import com.nesscomputing.jackson.SerializerBinderBuilder;
import com.nesscomputing.jackson.SerializerBinderBuilderImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public final class JacksonSerializerBinder {
    private JacksonSerializerBinder() {
    }

    public static <T> SerializerBinderBuilder<T> builderOf(Binder binder, final Class<T> type) {
        return new SerializerBinderBuilderImpl(binder, new TypeReference<T>(){

            @Override
            public Type getType() {
                return type;
            }
        });
    }

    public static <T> SerializerBinderBuilder<T> builderOf(Binder binder, TypeReference<T> type) {
        return new SerializerBinderBuilderImpl<T>(binder, type);
    }

    public static <T> SerializerBinderBuilder<T> builderOf(Binder binder, final TypeLiteral<T> literal) {
        TypeReference type = new TypeReference<T>(){

            @Override
            public Type getType() {
                return literal.getType();
            }
        };
        return new SerializerBinderBuilderImpl(binder, type);
    }

    public static <F, T> Key<Function<F, T>> keyFor(TypeReference<F> from2, TypeReference<T> to2, Class<? extends Annotation> annotation) {
        return Key.get((Type)Types.newParameterizedType(Function.class, new Type[]{from2.getType(), to2.getType()}), annotation);
    }
}

